/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.memory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.User;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.lib.AbstractUsersRepository;
import org.apache.james.user.lib.model.DefaultUser;

public class MemoryUsersRepository
extends AbstractUsersRepository {
    private final Map<String, org.apache.james.user.api.model.User> userByName = new HashMap<String, org.apache.james.user.api.model.User>();
    private final boolean supportVirtualHosting;
    private String algo = "MD5";

    public static MemoryUsersRepository withVirtualHosting() {
        return new MemoryUsersRepository(true);
    }

    public static MemoryUsersRepository withoutVirtualHosting() {
        return new MemoryUsersRepository(false);
    }

    private MemoryUsersRepository(boolean supportVirtualHosting) {
        this.supportVirtualHosting = supportVirtualHosting;
    }

    public void clear() {
        this.userByName.clear();
    }

    public boolean supportVirtualHosting() {
        return this.supportVirtualHosting;
    }

    public void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
        this.algo = config.getString("algorithm", "MD5");
        super.doConfigure(config);
    }

    protected void doAddUser(String username, String password) throws UsersRepositoryException {
        DefaultUser user = new DefaultUser(username, this.algo);
        user.setPassword(password);
        this.userByName.put(username.toLowerCase(Locale.US), (org.apache.james.user.api.model.User)user);
    }

    public org.apache.james.user.api.model.User getUserByName(String name) throws UsersRepositoryException {
        return this.userByName.get(name);
    }

    public void updateUser(org.apache.james.user.api.model.User user) throws UsersRepositoryException {
        org.apache.james.user.api.model.User existingUser = this.getUserByName(user.getUserName());
        if (existingUser == null) {
            throw new UsersRepositoryException("Please provide an existing user to update");
        }
        this.userByName.put(user.getUserName().toLowerCase(Locale.US), user);
    }

    public void removeUser(String name) throws UsersRepositoryException {
        if (this.userByName.remove(name) == null) {
            throw new UsersRepositoryException("unable to remove unknown user " + name);
        }
    }

    public boolean contains(String name) throws UsersRepositoryException {
        return this.userByName.containsKey(name.toLowerCase(Locale.US));
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        return Optional.ofNullable(this.userByName.get(User.fromUsername((String)name).asString())).map(user -> user.verifyPassword(password)).orElse(false);
    }

    public int countUsers() throws UsersRepositoryException {
        return this.userByName.size();
    }

    public Iterator<String> list() throws UsersRepositoryException {
        return this.userByName.keySet().iterator();
    }
}

