/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.memory;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.core.User;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.sieverepository.api.SieveQuotaRepository;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;

public class InMemorySieveQuotaRepository
implements SieveQuotaRepository {
    private Optional<QuotaSize> globalQuota = Optional.empty();
    private Map<User, QuotaSize> userQuota = new ConcurrentHashMap<User, QuotaSize>();

    public synchronized boolean hasDefaultQuota() {
        return this.globalQuota.isPresent();
    }

    public synchronized QuotaSize getDefaultQuota() throws QuotaNotFoundException {
        return this.globalQuota.orElseThrow(QuotaNotFoundException::new);
    }

    public synchronized void setDefaultQuota(QuotaSize quota) {
        this.globalQuota = Optional.of(quota);
    }

    public synchronized void removeQuota() throws QuotaNotFoundException {
        if (!this.globalQuota.isPresent()) {
            throw new QuotaNotFoundException();
        }
        this.globalQuota = Optional.empty();
    }

    public synchronized boolean hasQuota(User user) {
        return this.userQuota.containsKey(user);
    }

    public QuotaSize getQuota(User user) throws QuotaNotFoundException {
        return Optional.ofNullable(this.userQuota.get(user)).orElseThrow(QuotaNotFoundException::new);
    }

    public synchronized void setQuota(User user, QuotaSize quota) {
        this.userQuota.put(user, quota);
    }

    public synchronized void removeQuota(User user) throws QuotaNotFoundException {
        Optional<QuotaSize> quotaValue = Optional.ofNullable(this.userQuota.get(user));
        if (!quotaValue.isPresent()) {
            throw new QuotaNotFoundException();
        }
        this.userQuota.remove(user);
    }
}

