/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import java.util.List;
import java.util.Optional;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListeningMessageSearchIndex
implements MessageSearchIndex,
MailboxListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListeningMessageSearchIndex.class);
    public static final int UNLIMITED = -1;
    private final MessageMapperFactory factory;

    public ListeningMessageSearchIndex(MessageMapperFactory factory) {
        this.factory = factory;
    }

    protected MessageMapperFactory getFactory() {
        return this.factory;
    }

    public void event(Event event) {
        MailboxSession session = event.getSession();
        try {
            if (event instanceof MailboxListener.MessageEvent) {
                if (event instanceof EventFactory.AddedImpl) {
                    EventFactory.AddedImpl added = (EventFactory.AddedImpl)event;
                    Mailbox mailbox = added.getMailbox();
                    for (MessageUid next : added.getUids()) {
                        Optional<MailboxMessage> mailboxMessage = this.retrieveMailboxMessage(session, added, mailbox, next);
                        if (!mailboxMessage.isPresent()) continue;
                        this.addMessage(session, mailbox, mailboxMessage.get());
                    }
                } else if (event instanceof EventFactory.ExpungedImpl) {
                    EventFactory.ExpungedImpl expunged = (EventFactory.ExpungedImpl)event;
                    try {
                        this.delete(session, expunged.getMailbox(), expunged.getUids());
                    }
                    catch (MailboxException e) {
                        LOGGER.error("Unable to deleted messages {} from index for mailbox {}", new Object[]{expunged.getUids(), expunged.getMailbox(), e});
                    }
                } else if (event instanceof EventFactory.FlagsUpdatedImpl) {
                    EventFactory.FlagsUpdatedImpl flagsUpdated = (EventFactory.FlagsUpdatedImpl)event;
                    Mailbox mailbox = flagsUpdated.getMailbox();
                    try {
                        this.update(session, mailbox, flagsUpdated.getUpdatedFlags());
                    }
                    catch (MailboxException e) {
                        LOGGER.error("Unable to update flags in index for mailbox {}", (Object)mailbox, (Object)e);
                    }
                }
            } else if (event instanceof EventFactory.MailboxDeletionImpl) {
                this.deleteAll(session, ((EventFactory.MailboxDeletionImpl)event).getMailbox());
            }
        }
        catch (MailboxException e) {
            LOGGER.error("Unable to update index", (Throwable)e);
        }
    }

    private Optional<MailboxMessage> retrieveMailboxMessage(MailboxSession session, EventFactory.AddedImpl added, Mailbox mailbox, MessageUid next) {
        Optional<MailboxMessage> firstChoice = Optional.ofNullable(added.getAvailableMessages().get(next));
        if (firstChoice.isPresent()) {
            return firstChoice;
        }
        try {
            return Optional.of(this.factory.getMessageMapper(session).findInMailbox(mailbox, MessageRange.one((MessageUid)next), MessageMapper.FetchType.Full, -1).next());
        }
        catch (Exception e) {
            LOGGER.error("Could not retrieve message {} in mailbox {}", new Object[]{next, mailbox.getMailboxId().serialize(), e});
            return Optional.empty();
        }
    }

    private void addMessage(MailboxSession session, Mailbox mailbox, MailboxMessage message) {
        try {
            this.add(session, mailbox, message);
        }
        catch (MailboxException e) {
            LOGGER.error("Unable to index message {} for mailbox {}", new Object[]{message.getUid(), mailbox, e});
        }
    }

    public abstract void add(MailboxSession var1, Mailbox var2, MailboxMessage var3) throws MailboxException;

    public abstract void delete(MailboxSession var1, Mailbox var2, List<MessageUid> var3) throws MailboxException;

    public abstract void deleteAll(MailboxSession var1, Mailbox var2) throws MailboxException;

    public abstract void update(MailboxSession var1, Mailbox var2, List<UpdatedFlags> var3) throws MailboxException;
}

