/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import java.util.List;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.quota.QuotaUpdater;
import org.apache.james.mailbox.store.quota.StoreCurrentQuotaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListeningCurrentQuotaUpdater
implements MailboxListener,
QuotaUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListeningCurrentQuotaUpdater.class);
    private final StoreCurrentQuotaManager currentQuotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final MailboxEventDispatcher dispatcher;
    private final QuotaManager quotaManager;

    @Inject
    public ListeningCurrentQuotaUpdater(StoreCurrentQuotaManager currentQuotaManager, QuotaRootResolver quotaRootResolver, MailboxEventDispatcher dispatcher, QuotaManager quotaManager) {
        this.currentQuotaManager = currentQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.dispatcher = dispatcher;
        this.quotaManager = quotaManager;
    }

    public MailboxListener.ListenerType getType() {
        return this.currentQuotaManager.getAssociatedListenerType();
    }

    public void event(Event event) {
        try {
            if (event instanceof MailboxListener.Added) {
                MailboxListener.Added addedEvent = (MailboxListener.Added)event;
                QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(addedEvent.getMailboxPath());
                this.handleAddedEvent(addedEvent, quotaRoot);
            } else if (event instanceof MailboxListener.Expunged) {
                MailboxListener.Expunged expungedEvent = (MailboxListener.Expunged)event;
                QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(expungedEvent.getMailboxPath());
                this.handleExpungedEvent(expungedEvent, quotaRoot);
            }
        }
        catch (MailboxException e) {
            LOGGER.error("Error while updating quotas", (Throwable)e);
        }
    }

    private void handleExpungedEvent(MailboxListener.Expunged expunged, QuotaRoot quotaRoot) throws MailboxException {
        long addedSize = 0L;
        long addedCount = 0L;
        List uids = expunged.getUids();
        for (MessageUid uid : uids) {
            addedSize += expunged.getMetaData(uid).getSize();
            ++addedCount;
        }
        if (addedCount != 0L && addedSize != 0L) {
            this.currentQuotaManager.decrease(quotaRoot, addedCount, addedSize);
        }
        this.dispatcher.quota(expunged.getSession(), quotaRoot, (Quota<QuotaCount>)this.quotaManager.getMessageQuota(quotaRoot), (Quota<QuotaSize>)this.quotaManager.getStorageQuota(quotaRoot));
    }

    private void handleAddedEvent(MailboxListener.Added added, QuotaRoot quotaRoot) throws MailboxException {
        long addedSize = 0L;
        long addedCount = 0L;
        List uids = added.getUids();
        for (MessageUid uid : uids) {
            addedSize += added.getMetaData(uid).getSize();
            ++addedCount;
        }
        if (addedCount != 0L && addedSize != 0L) {
            this.currentQuotaManager.increase(quotaRoot, addedCount, addedSize);
        }
        this.dispatcher.quota(added.getSession(), quotaRoot, (Quota<QuotaCount>)this.quotaManager.getMessageQuota(quotaRoot), (Quota<QuotaSize>)this.quotaManager.getStorageQuota(quotaRoot));
    }
}

