/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.mailbox.model.Attachment;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentIdField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.util.MimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser {
    private static final String TEXT_MEDIA_TYPE = "text";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_ID = "Content-ID";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final List<String> ATTACHMENT_CONTENT_DISPOSITIONS = ImmutableList.of((Object)"attachment".toLowerCase(Locale.US), (Object)"inline".toLowerCase(Locale.US));
    private static final String TEXT_CALENDAR = "text/calendar";
    private static final ImmutableList<String> ATTACHMENT_CONTENT_TYPES = ImmutableList.of((Object)"application/pgp-signature", (Object)"message/disposition-notification", (Object)"text/calendar");
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageParser.class);
    private final Cid.CidParser cidParser = Cid.parser().relaxed().unwrap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageAttachment> retrieveAttachments(InputStream fullContent) throws MimeException, IOException {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        defaultMessageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        Message message = defaultMessageBuilder.parseMessage(fullContent);
        Body body = message.getBody();
        try {
            if (this.isAttachment((Entity)message, Context.BODY)) {
                ImmutableList immutableList = ImmutableList.of((Object)this.retrieveAttachment((Entity)message));
                return immutableList;
            }
            if (body instanceof Multipart) {
                Multipart multipartBody = (Multipart)body;
                List list = (List)this.listAttachments(multipartBody, Context.fromSubType(multipartBody.getSubType())).collect(Guavate.toImmutableList());
                return list;
            }
            ImmutableList immutableList = ImmutableList.of();
            return immutableList;
        }
        finally {
            body.dispose();
        }
    }

    private Stream<MessageAttachment> listAttachments(Multipart multipart, Context context) {
        return multipart.getBodyParts().stream().flatMap(entity -> this.listAttachments((Entity)entity, context));
    }

    private Stream<MessageAttachment> listAttachments(Entity entity, Context context) {
        if (this.isMultipart(entity)) {
            return this.listAttachments((Multipart)entity.getBody(), Context.fromEntity(entity));
        }
        if (this.isAttachment(entity, context)) {
            try {
                return Stream.of(this.retrieveAttachment(entity));
            }
            catch (IllegalStateException e) {
                LOGGER.warn("The attachment is not well-formed", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.warn("There is an error when retrieving attachment", (Throwable)e);
            }
        }
        return Stream.empty();
    }

    private MessageAttachment retrieveAttachment(Entity entity) throws IOException {
        Optional<ContentTypeField> contentTypeField = this.getContentTypeField(entity);
        Optional<ContentDispositionField> contentDispositionField = this.getContentDispositionField(entity);
        Optional<String> contentType = this.contentType(contentTypeField);
        Optional<String> name = this.name(contentTypeField, contentDispositionField);
        Optional<Cid> cid = this.cid(this.readHeader(entity, CONTENT_ID, ContentIdField.class));
        boolean isInline = this.isInline(this.readHeader(entity, CONTENT_DISPOSITION, ContentDispositionField.class)) && cid.isPresent();
        return MessageAttachment.builder().attachment(Attachment.builder().bytes(this.getBytes(entity.getBody())).type(contentType.orElse(DEFAULT_CONTENT_TYPE)).build()).name((String)name.orElse(null)).cid((Cid)cid.orElse(null)).isInline(Boolean.valueOf(isInline)).build();
    }

    private <T extends ParsedField> Optional<T> readHeader(Entity entity, String headerName, Class<T> clazz) {
        return this.castField(entity.getHeader().getField(headerName), clazz);
    }

    private Optional<ContentTypeField> getContentTypeField(Entity entity) {
        return this.castField(entity.getHeader().getField(CONTENT_TYPE), ContentTypeField.class);
    }

    private Optional<ContentDispositionField> getContentDispositionField(Entity entity) {
        return this.castField(entity.getHeader().getField(CONTENT_DISPOSITION), ContentDispositionField.class);
    }

    private <U extends ParsedField> Optional<U> castField(Field field, Class<U> clazz) {
        if (field == null || !clazz.isInstance(field)) {
            return Optional.empty();
        }
        return Optional.of((ParsedField)field);
    }

    private Optional<String> contentType(Optional<ContentTypeField> contentTypeField) {
        return contentTypeField.map(ContentTypeField::getMimeType);
    }

    private Optional<String> name(Optional<ContentTypeField> contentTypeField, Optional<ContentDispositionField> contentDispositionField) {
        return contentTypeField.map(field -> Optional.ofNullable(field.getParameter("name"))).filter(Optional::isPresent).orElseGet(() -> contentDispositionField.map(ContentDispositionField::getFilename)).map(MimeUtil::unscrambleHeaderValue);
    }

    private Optional<Cid> cid(Optional<ContentIdField> contentIdField) {
        return contentIdField.map(ContentIdField::getId).flatMap(arg_0 -> ((Cid.CidParser)this.cidParser).parse(arg_0));
    }

    private boolean isMultipart(Entity entity) {
        return entity.isMultipart() && entity.getBody() instanceof Multipart;
    }

    private boolean isInline(Optional<ContentDispositionField> contentDispositionField) {
        return contentDispositionField.map(ContentDispositionField::isInline).orElse(false);
    }

    private boolean isAttachment(Entity part, Context context) {
        if (context == Context.BODY && this.isTextPart(part)) {
            return false;
        }
        return this.attachmentDispositionCriterion(part) != false || this.attachmentContentTypeCriterion(part) != false;
    }

    private boolean isTextPart(Entity part) {
        return this.getContentTypeField(part).filter(header -> !ATTACHMENT_CONTENT_TYPES.contains((Object)header.getMimeType())).map(ContentTypeField::getMediaType).map(TEXT_MEDIA_TYPE::equals).orElse(false);
    }

    private Boolean attachmentContentTypeCriterion(Entity part) {
        return this.getContentTypeField(part).map(ContentTypeField::getMimeType).map(dispositionType -> dispositionType.toLowerCase(Locale.US)).map(arg_0 -> ATTACHMENT_CONTENT_TYPES.contains(arg_0)).orElse(false);
    }

    private Boolean attachmentDispositionCriterion(Entity part) {
        return this.getContentDispositionField(part).map(ContentDispositionField::getDispositionType).map(dispositionType -> dispositionType.toLowerCase(Locale.US)).map(ATTACHMENT_CONTENT_DISPOSITIONS::contains).orElse(false);
    }

    private byte[] getBytes(Body body) throws IOException {
        DefaultMessageWriter messageWriter = new DefaultMessageWriter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        messageWriter.writeBody(body, (OutputStream)out);
        return out.toByteArray();
    }

    private static enum Context {
        BODY,
        OTHER;

        private static final String ALTERNATIVE_SUB_TYPE = "alternative";
        private static final String MULTIPART_ALTERNATIVE = "multipart/alternative";

        public static Context fromEntity(Entity entity) {
            if (Context.isMultipartAlternative(entity)) {
                return BODY;
            }
            return OTHER;
        }

        public static Context fromSubType(String subPart) {
            if (Context.isAlternative(subPart)) {
                return BODY;
            }
            return OTHER;
        }

        private static boolean isMultipartAlternative(Entity entity) {
            return entity.getMimeType().equalsIgnoreCase(MULTIPART_ALTERNATIVE);
        }

        private static boolean isAlternative(String subPart) {
            return subPart.equalsIgnoreCase(ALTERNATIVE_SUB_TYPE);
        }
    }
}

