/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.quota.QuotaValue;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.store.mail.model.SerializableQuotaValue;

public class SerializableQuota<T extends QuotaValue<T>>
implements Serializable {
    public static final long UNLIMITED = -1L;
    private final SerializableQuotaValue<T> max;
    private final SerializableQuotaValue<T> used;

    public static <U extends QuotaValue<U>> SerializableQuota<U> newInstance(Quota<U> quota) {
        return SerializableQuota.newInstance(quota.getUsed(), quota.getLimit());
    }

    public static <U extends QuotaValue<U>> SerializableQuota<U> newInstance(U used, U max) {
        return new SerializableQuota<U>(new SerializableQuotaValue<U>(used), new SerializableQuotaValue<U>(max));
    }

    private SerializableQuota(SerializableQuotaValue<T> used, SerializableQuotaValue<T> max) {
        this.max = max;
        this.used = used;
    }

    public Long encodeAsLong() {
        return this.max.encodeAsLong();
    }

    public Long getUsed() {
        return Optional.ofNullable(this.used).map(SerializableQuotaValue::encodeAsLong).orElse(null);
    }

    public boolean equals(Object o) {
        if (o instanceof SerializableQuota) {
            SerializableQuota that = (SerializableQuota)o;
            return Objects.equals(this.max, that.max) && Objects.equals(this.used, that.used);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.max, this.used);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("max", this.max).add("used", this.used).toString();
    }
}

