/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json.event.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class MailboxDataTransferObject {
    @JsonProperty
    private String serializedMailboxId;
    @JsonProperty
    private String namespace;
    @JsonProperty
    private String user;
    @JsonProperty
    private String name;
    @JsonProperty
    private long uidValidity;
    @JsonProperty
    private String serializedACL;

    public static Builder builder() {
        return new Builder();
    }

    public MailboxDataTransferObject() {
    }

    private MailboxDataTransferObject(String serializedMailboxId, String namespace, String user, String name, long uidValidity, String serializedACL) {
        this.serializedMailboxId = serializedMailboxId;
        this.namespace = namespace;
        this.user = user;
        this.name = name;
        this.uidValidity = uidValidity;
        this.serializedACL = serializedACL;
    }

    @JsonIgnore
    public String getSerializedMailboxId() {
        return this.serializedMailboxId;
    }

    @JsonIgnore
    public String getNamespace() {
        return this.namespace;
    }

    @JsonIgnore
    public String getUser() {
        return this.user;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public long getUidValidity() {
        return this.uidValidity;
    }

    @JsonIgnore
    public String getSerializedACL() {
        return this.serializedACL;
    }

    public static class Builder {
        private String serializedMailboxId;
        private String namespace;
        private String user;
        private String name;
        private long uidValidity;
        private String serializedACL;

        private Builder() {
        }

        public Builder serializedMailboxId(String serializedMailboxId) {
            this.serializedMailboxId = serializedMailboxId;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder uidValidity(long uidValidity) {
            this.uidValidity = uidValidity;
            return this;
        }

        public Builder serializedACL(String serializedACL) {
            this.serializedACL = serializedACL;
            return this;
        }

        public MailboxDataTransferObject build() {
            return new MailboxDataTransferObject(this.serializedMailboxId, this.namespace, this.user, this.name, this.uidValidity, this.serializedACL);
        }
    }
}

