/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json.event.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.store.json.event.dto.EventType;
import org.apache.james.mailbox.store.json.event.dto.MailboxDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.MailboxPathDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.MailboxSessionDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.MessageMetaDataDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.UpdatedFlagsDataTransferObject;

public class EventDataTransferObject {
    @JsonProperty
    private EventType type;
    @JsonProperty
    private MailboxDataTransferObject mailbox;
    @JsonProperty
    private MailboxSessionDataTransferObject session;
    @JsonProperty
    private List<MessageUid> uids;
    @JsonProperty
    private Map<MessageUid, MessageMetaDataDataTransferObject> metaData;
    @JsonProperty
    private List<UpdatedFlagsDataTransferObject> updatedFlags;
    @JsonProperty
    private MailboxPathDataTransferObject from;

    public static Builder builder() {
        return new Builder();
    }

    public EventDataTransferObject() {
    }

    public EventDataTransferObject(EventType type, MailboxDataTransferObject mailbox, MailboxSessionDataTransferObject session, List<MessageUid> uids, Map<MessageUid, MessageMetaDataDataTransferObject> metaData, List<UpdatedFlagsDataTransferObject> updatedFlags, MailboxPathDataTransferObject from) {
        this.type = type;
        this.mailbox = mailbox;
        this.session = session;
        this.uids = uids;
        this.metaData = metaData;
        this.updatedFlags = updatedFlags;
        this.from = from;
    }

    @JsonIgnore
    public EventType getType() {
        return this.type;
    }

    @JsonIgnore
    public MailboxDataTransferObject getMailbox() {
        return this.mailbox;
    }

    @JsonIgnore
    public MailboxSessionDataTransferObject getSession() {
        return this.session;
    }

    @JsonIgnore
    public List<MessageUid> getUids() {
        return this.uids;
    }

    @JsonIgnore
    public Map<MessageUid, MessageMetaDataDataTransferObject> getMetaDataProxyMap() {
        return this.metaData;
    }

    @JsonIgnore
    public List<UpdatedFlagsDataTransferObject> getUpdatedFlags() {
        return this.updatedFlags;
    }

    @JsonIgnore
    public MailboxPathDataTransferObject getFrom() {
        return this.from;
    }

    public static class Builder {
        private EventType type;
        private MailboxDataTransferObject mailbox;
        private MailboxSessionDataTransferObject session;
        private List<MessageUid> uids;
        private Map<MessageUid, MessageMetaDataDataTransferObject> metaData;
        private List<UpdatedFlagsDataTransferObject> updatedFlags;
        private MailboxPathDataTransferObject from;

        public Builder type(EventType type) {
            this.type = type;
            return this;
        }

        public Builder mailbox(MailboxDataTransferObject mailbox) {
            this.mailbox = mailbox;
            return this;
        }

        public Builder session(MailboxSessionDataTransferObject session) {
            this.session = session;
            return this;
        }

        public Builder from(MailboxPathDataTransferObject from) {
            this.from = from;
            return this;
        }

        public Builder uids(List<MessageUid> uids) {
            this.uids = uids;
            return this;
        }

        public Builder metaData(Map<MessageUid, MessageMetaDataDataTransferObject> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder updatedFlags(List<UpdatedFlagsDataTransferObject> updatedFlagsList) {
            this.updatedFlags = updatedFlagsList;
            return this;
        }

        public EventDataTransferObject build() {
            return new EventDataTransferObject(this.type, this.mailbox, this.session, this.uids, this.metaData, this.updatedFlags, this.from);
        }
    }
}

