/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.event.EventSerializer;
import org.apache.james.mailbox.store.json.event.EventConverter;
import org.apache.james.mailbox.store.json.event.dto.EventDataTransferObject;

public class JacksonEventSerializer
implements EventSerializer {
    private final EventConverter eventConverter;
    private final ObjectMapper objectMapper;

    public JacksonEventSerializer(EventConverter eventConverter, ObjectMapper objectMapper) {
        this.eventConverter = eventConverter;
        this.objectMapper = objectMapper;
    }

    @Override
    public byte[] serializeEvent(MailboxListener.MailboxEvent event) throws Exception {
        return this.objectMapper.writeValueAsBytes((Object)this.eventConverter.convertToDataTransferObject(event));
    }

    @Override
    public MailboxListener.MailboxEvent deSerializeEvent(byte[] serializedEvent) throws Exception {
        EventDataTransferObject eventDataTransferObject = (EventDataTransferObject)this.objectMapper.readValue(serializedEvent, EventDataTransferObject.class);
        return this.eventConverter.retrieveEvent(eventDataTransferObject);
    }

    public static ObjectMapper configureObjectMapper(ObjectMapper objectMapper, MessageId.Factory messageIdFactory) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(MessageUid.class, (JsonDeserializer)new MessageUidDeserializer());
        module.addKeyDeserializer(MessageUid.class, (KeyDeserializer)new MessageUidKeyDeserializer());
        module.addSerializer(MessageUid.class, (JsonSerializer)new MessageUidSerializer());
        module.addKeySerializer(MessageUid.class, (JsonSerializer)new MessageUidKeySerializer());
        module.addSerializer(MessageId.class, (JsonSerializer)new MessageIdSerializer());
        module.addDeserializer(MessageId.class, (JsonDeserializer)new MessageIdDeserializer(messageIdFactory));
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    public static class MessageIdDeserializer
    extends JsonDeserializer<MessageId> {
        private final MessageId.Factory factory;

        public MessageIdDeserializer(MessageId.Factory factory) {
            this.factory = factory;
        }

        public MessageId deserialize(JsonParser p, DeserializationContext context) throws IOException, JsonProcessingException {
            return this.factory.fromString(p.getValueAsString());
        }
    }

    public static class MessageIdSerializer
    extends JsonSerializer<MessageId> {
        public void serialize(MessageId value, JsonGenerator generator, SerializerProvider serializers) throws IOException, JsonProcessingException {
            generator.writeString(String.valueOf(value.serialize()));
        }
    }

    public static class MessageUidKeySerializer
    extends JsonSerializer<MessageUid> {
        public void serialize(MessageUid value, JsonGenerator generator, SerializerProvider serializers) throws IOException, JsonProcessingException {
            generator.writeFieldName(String.valueOf(value.asLong()));
        }
    }

    public static class MessageUidKeyDeserializer
    extends KeyDeserializer {
        public Object deserializeKey(String key, DeserializationContext context) throws IOException, JsonProcessingException {
            return MessageUid.of((long)Long.parseLong(key));
        }
    }

    public static class MessageUidSerializer
    extends JsonSerializer<MessageUid> {
        public void serialize(MessageUid value, JsonGenerator generator, SerializerProvider serializers) throws IOException, JsonProcessingException {
            generator.writeString(String.valueOf(value.asLong()));
        }
    }

    public static class MessageUidDeserializer
    extends JsonDeserializer<MessageUid> {
        public MessageUid deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            return MessageUid.of((long)Long.parseLong(parser.getValueAsString()));
        }
    }
}

