/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event.distributed;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.event.EventDelivery;
import org.apache.james.mailbox.store.event.EventSerializer;
import org.apache.james.mailbox.store.event.MailboxListenerRegistry;
import org.apache.james.mailbox.store.event.SynchronousEventDelivery;
import org.apache.james.mailbox.store.event.distributed.DistributedDelegatingMailboxListener;
import org.apache.james.mailbox.store.event.distributed.MailboxPathRegister;
import org.apache.james.mailbox.store.publisher.MessageConsumer;
import org.apache.james.mailbox.store.publisher.Publisher;
import org.apache.james.mailbox.store.publisher.Topic;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopMetricFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredDelegatingMailboxListener
implements DistributedDelegatingMailboxListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredDelegatingMailboxListener.class);
    private final MailboxListenerRegistry mailboxListenerRegistry;
    private final MailboxPathRegister mailboxPathRegister;
    private final Publisher publisher;
    private final EventSerializer eventSerializer;
    private final EventDelivery eventDelivery;

    public RegisteredDelegatingMailboxListener(EventSerializer eventSerializer, Publisher publisher, MessageConsumer messageConsumer, MailboxPathRegister mailboxPathRegister, EventDelivery eventDelivery) throws Exception {
        this.eventSerializer = eventSerializer;
        this.publisher = publisher;
        this.mailboxPathRegister = mailboxPathRegister;
        this.mailboxListenerRegistry = new MailboxListenerRegistry();
        this.eventDelivery = eventDelivery;
        messageConsumer.setMessageReceiver(this);
        messageConsumer.init(mailboxPathRegister.getLocalTopic());
    }

    @VisibleForTesting
    public RegisteredDelegatingMailboxListener(EventSerializer eventSerializer, Publisher publisher, MessageConsumer messageConsumer, MailboxPathRegister mailboxPathRegister) throws Exception {
        this(eventSerializer, publisher, messageConsumer, mailboxPathRegister, new SynchronousEventDelivery((MetricFactory)new NoopMetricFactory()));
    }

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.ONCE;
    }

    public void addListener(MailboxPath path, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.addListener(path, listener);
        this.mailboxPathRegister.register(path);
    }

    public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        if (listener.getType().equals((Object)MailboxListener.ListenerType.EACH_NODE)) {
            throw new MailboxException("Attempt to register a global listener that need to be called on each node while using a non compatible delegating listeners");
        }
        this.mailboxListenerRegistry.addGlobalListener(listener);
    }

    public void removeListener(MailboxPath mailboxPath, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.removeListener(mailboxPath, listener);
        this.mailboxPathRegister.unregister(mailboxPath);
    }

    public void removeGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.removeGlobalListener(listener);
    }

    public void event(Event event) {
        try {
            this.deliverEventToOnceGlobalListeners(event);
            this.deliverToMailboxPathRegisteredListeners(event);
            if (event instanceof MailboxListener.MailboxEvent) {
                MailboxListener.MailboxEvent mailboxEvent = (MailboxListener.MailboxEvent)event;
                this.sendToRemoteJames(mailboxEvent);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error while delegating event {}", (Object)event.getClass().getCanonicalName(), (Object)t);
        }
    }

    @Override
    public void receiveSerializedEvent(byte[] serializedEvent) {
        try {
            MailboxListener.MailboxEvent event = this.eventSerializer.deSerializeEvent(serializedEvent);
            this.deliverToMailboxPathRegisteredListeners(event);
        }
        catch (Exception e) {
            LOGGER.error("Error while receiving serialized event", (Throwable)e);
        }
    }

    private void deliverToMailboxPathRegisteredListeners(Event event) throws MailboxException {
        if (event instanceof MailboxListener.MailboxEvent) {
            MailboxListener.MailboxEvent mailboxEvent = (MailboxListener.MailboxEvent)event;
            this.deliverToMailboxPathRegisteredListeners(mailboxEvent);
        }
    }

    private void deliverToMailboxPathRegisteredListeners(MailboxListener.MailboxEvent mailboxEvent) throws MailboxException {
        List<MailboxListener> listenerSnapshot = this.mailboxListenerRegistry.getLocalMailboxListeners(mailboxEvent.getMailboxPath());
        if (mailboxEvent instanceof MailboxListener.MailboxDeletion && listenerSnapshot.size() > 0) {
            this.mailboxListenerRegistry.deleteRegistryFor(mailboxEvent.getMailboxPath());
            this.mailboxPathRegister.doCompleteUnRegister(mailboxEvent.getMailboxPath());
        } else if (mailboxEvent instanceof MailboxListener.MailboxRenamed && listenerSnapshot.size() > 0) {
            MailboxListener.MailboxRenamed renamed = (MailboxListener.MailboxRenamed)mailboxEvent;
            this.mailboxListenerRegistry.handleRename(renamed.getMailboxPath(), renamed.getNewPath());
            this.mailboxPathRegister.doRename(renamed.getMailboxPath(), renamed.getNewPath());
        }
        for (MailboxListener listener : listenerSnapshot) {
            this.eventDelivery.deliver(listener, (Event)mailboxEvent);
        }
    }

    private void deliverEventToOnceGlobalListeners(Event event) {
        for (MailboxListener mailboxListener : this.mailboxListenerRegistry.getGlobalListeners()) {
            if (mailboxListener.getType() != MailboxListener.ListenerType.ONCE) continue;
            this.eventDelivery.deliver(mailboxListener, event);
        }
    }

    private void sendToRemoteJames(MailboxListener.MailboxEvent event) {
        Set<Topic> topics = this.mailboxPathRegister.getTopics(event.getMailboxPath());
        topics.remove(this.mailboxPathRegister.getLocalTopic());
        if (topics.size() > 0) {
            this.sendEventToRemotesJamesByTopic(event, topics);
        }
    }

    private void sendEventToRemotesJamesByTopic(MailboxListener.MailboxEvent event, Set<Topic> topics) {
        byte[] serializedEvent;
        try {
            serializedEvent = this.eventSerializer.serializeEvent(event);
        }
        catch (Exception e) {
            LOGGER.error("Unable to serialize {}", (Object)event.getClass().getCanonicalName(), (Object)e);
            return;
        }
        for (Topic topic : topics) {
            try {
                this.publisher.publish(topic, serializedEvent);
            }
            catch (Throwable t) {
                LOGGER.error("Unable to send serialized event to topic {}", (Object)topic);
            }
        }
    }
}

