/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class MessageMoveEvent
implements Event {
    private final MailboxSession session;
    private final MessageMoves messageMoves;
    private final Map<MessageUid, MailboxMessage> messages;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    MessageMoveEvent(MailboxSession session, MessageMoves messageMoves, Map<MessageUid, MailboxMessage> messages) {
        this.session = session;
        this.messageMoves = messageMoves;
        this.messages = messages;
    }

    public boolean isNoop() {
        return this.messages.isEmpty();
    }

    public MailboxSession getSession() {
        return this.session;
    }

    public MessageMoves getMessageMoves() {
        return this.messageMoves;
    }

    public Map<MessageUid, MailboxMessage> getMessages() {
        return this.messages;
    }

    public boolean isMoveTo(MailboxId mailboxId) {
        return this.messageMoves.addedMailboxIds().contains(mailboxId);
    }

    public boolean isMoveFrom(MailboxId mailboxId) {
        return this.messageMoves.removedMailboxIds().contains(mailboxId);
    }

    public static class Builder {
        private MailboxSession session;
        private MessageMoves messageMoves;
        private ImmutableMap.Builder<MessageUid, MailboxMessage> messagesBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder session(MailboxSession session) {
            this.session = session;
            return this;
        }

        public Builder messageMoves(MessageMoves messageMoves) {
            this.messageMoves = messageMoves;
            return this;
        }

        public Builder messages(Map<MessageUid, MailboxMessage> messages) {
            this.messagesBuilder.putAll(messages);
            return this;
        }

        public MessageMoveEvent build() {
            Preconditions.checkNotNull((Object)this.session, (Object)"'session' is mandatory");
            Preconditions.checkNotNull((Object)this.messageMoves, (Object)"'messageMoves' is mandatory");
            ImmutableMap messages = this.messagesBuilder.build();
            return new MessageMoveEvent(this.session, this.messageMoves, (Map<MessageUid, MailboxMessage>)messages);
        }
    }
}

