/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.event.MessageMoveEvent;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class MailboxEventDispatcher {
    private final MailboxListener listener;
    private final EventFactory eventFactory;

    @VisibleForTesting
    public static MailboxEventDispatcher ofListener(MailboxListener mailboxListener) {
        return new MailboxEventDispatcher(mailboxListener, new EventFactory());
    }

    @Inject
    public MailboxEventDispatcher(DelegatingMailboxListener delegatingMailboxListener) {
        this(delegatingMailboxListener, new EventFactory());
    }

    private MailboxEventDispatcher(MailboxListener listener, EventFactory eventFactory) {
        this.listener = listener;
        this.eventFactory = eventFactory;
    }

    public void added(MailboxSession session, SortedMap<MessageUid, MessageMetaData> uids, Mailbox mailbox, Map<MessageUid, MailboxMessage> cachedMessages) {
        this.listener.event((Event)this.eventFactory.added(session, uids, mailbox, cachedMessages));
    }

    public void added(MailboxSession session, Mailbox mailbox, MailboxMessage mailboxMessage) {
        SimpleMessageMetaData messageMetaData = new SimpleMessageMetaData(mailboxMessage);
        ImmutableSortedMap metaDataMap = ImmutableSortedMap.naturalOrder().put((Object)messageMetaData.getUid(), (Object)messageMetaData).build();
        this.added(session, (SortedMap<MessageUid, MessageMetaData>)metaDataMap, mailbox, (Map<MessageUid, MailboxMessage>)ImmutableMap.of((Object)mailboxMessage.getUid(), (Object)mailboxMessage));
    }

    public void added(MailboxSession session, MessageMetaData messageMetaData, Mailbox mailbox) {
        ImmutableSortedMap metaDataMap = ImmutableSortedMap.naturalOrder().put((Object)messageMetaData.getUid(), (Object)messageMetaData).build();
        this.added(session, (SortedMap<MessageUid, MessageMetaData>)metaDataMap, mailbox, (Map<MessageUid, MailboxMessage>)ImmutableMap.of());
    }

    public void expunged(MailboxSession session, Map<MessageUid, MessageMetaData> uids, Mailbox mailbox) {
        if (!uids.isEmpty()) {
            this.listener.event((Event)this.eventFactory.expunged(session, uids, mailbox));
        }
    }

    public void expunged(MailboxSession session, MessageMetaData messageMetaData, Mailbox mailbox) {
        ImmutableMap metaDataMap = ImmutableMap.builder().put((Object)messageMetaData.getUid(), (Object)messageMetaData).build();
        this.expunged(session, (Map<MessageUid, MessageMetaData>)metaDataMap, mailbox);
    }

    public void flagsUpdated(MailboxSession session, List<MessageUid> uids, Mailbox mailbox, List<UpdatedFlags> uflags) {
        if (!uids.isEmpty()) {
            this.listener.event((Event)this.eventFactory.flagsUpdated(session, uids, mailbox, uflags));
        }
    }

    public void flagsUpdated(MailboxSession session, MessageUid uid, Mailbox mailbox, UpdatedFlags uflags) {
        this.flagsUpdated(session, (List<MessageUid>)ImmutableList.of((Object)uid), mailbox, (List<UpdatedFlags>)ImmutableList.of((Object)uflags));
    }

    public void mailboxRenamed(MailboxSession session, MailboxPath from, Mailbox to) {
        this.listener.event((Event)this.eventFactory.mailboxRenamed(session, from, to));
    }

    public void mailboxDeleted(MailboxSession session, Mailbox mailbox) {
        this.listener.event((Event)this.eventFactory.mailboxDeleted(session, mailbox));
    }

    public void mailboxAdded(MailboxSession session, Mailbox mailbox) {
        this.listener.event((Event)this.eventFactory.mailboxAdded(session, mailbox));
    }

    public void aclUpdated(MailboxSession session, MailboxPath mailboxPath, ACLDiff aclDiff) {
        this.listener.event((Event)this.eventFactory.aclUpdated(session, mailboxPath, aclDiff));
    }

    public void moved(MailboxSession session, MessageMoves messageMoves, Map<MessageUid, MailboxMessage> messages) {
        MessageMoveEvent moveEvent = this.eventFactory.moved(session, messageMoves, messages);
        if (!moveEvent.isNoop()) {
            this.listener.event((Event)moveEvent);
        }
    }

    public void quota(MailboxSession session, QuotaRoot quotaRoot, Quota<QuotaCount> countQuota, Quota<QuotaSize> sizeQuota) {
        this.listener.event((Event)new MailboxListener.QuotaUsageUpdatedEvent(session, quotaRoot, countQuota, sizeQuota, Instant.now()));
    }

    public void event(Event event) {
        this.listener.event(event);
    }
}

