/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.store.event.EventDelivery;
import org.apache.james.mailbox.store.event.SynchronousEventDelivery;

public class AsynchronousEventDelivery
implements EventDelivery {
    private final ExecutorService threadPoolExecutor;
    private final SynchronousEventDelivery synchronousEventDelivery;

    public AsynchronousEventDelivery(int threadPoolSize, SynchronousEventDelivery synchronousEventDelivery) {
        this.threadPoolExecutor = Executors.newFixedThreadPool(threadPoolSize);
        this.synchronousEventDelivery = synchronousEventDelivery;
    }

    @Override
    public void deliver(MailboxListener mailboxListener, Event event) {
        this.threadPoolExecutor.submit(() -> this.synchronousEventDelivery.deliver(mailboxListener, event));
    }

    @PreDestroy
    public void stop() {
        this.threadPoolExecutor.shutdownNow();
    }
}

