/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.Objects;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.MimeDescriptor;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMessageResultIterator
implements MessageResultIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMessageResultIterator.class);
    private Iterator<MailboxMessage> next = null;
    private MailboxException exception;
    private final Mailbox mailbox;
    private final MessageResult.FetchGroup group;
    private final MessageUid from;
    private MessageUid cursor;
    private final MessageUid to;
    private final BatchSizes batchSizes;
    private final MessageRange.Type type;
    private final MessageMapper mapper;
    private final MessageMapper.FetchType ftype;

    public StoreMessageResultIterator(MessageMapper mapper, Mailbox mailbox, MessageRange range, BatchSizes batchSizes, MessageResult.FetchGroup group) {
        this.mailbox = mailbox;
        this.group = group;
        this.mapper = mapper;
        this.cursor = this.from = range.getUidFrom();
        this.to = range.getUidTo();
        this.batchSizes = batchSizes;
        this.type = range.getType();
        this.ftype = StoreMessageResultIterator.getFetchType(group);
        LOGGER.debug("batchSizes used: {}", (Object)batchSizes);
    }

    private static MessageMapper.FetchType getFetchType(MessageResult.FetchGroup group) {
        int content = group.content();
        boolean headers = false;
        boolean body = false;
        boolean full = false;
        if ((content & 0x100) > 0) {
            headers = true;
            content -= 256;
        }
        if (group.getPartContentDescriptors().size() > 0) {
            full = true;
        }
        if ((content & 0x400) > 0) {
            body = true;
            content -= 1024;
        }
        if ((content & 0x200) > 0) {
            full = true;
            content -= 512;
        }
        if ((content & 1) > 0) {
            full = true;
            --content;
        }
        if (full || body && headers) {
            return MessageMapper.FetchType.Full;
        }
        if (body) {
            return MessageMapper.FetchType.Body;
        }
        if (headers) {
            return MessageMapper.FetchType.Headers;
        }
        return MessageMapper.FetchType.Metadata;
    }

    public boolean hasNext() {
        if (this.cursor.compareTo(this.to) > 0) {
            return false;
        }
        if (this.next == null || !this.next.hasNext()) {
            try {
                this.readBatch();
            }
            catch (MailboxException e) {
                this.exception = e;
                return false;
            }
        }
        return this.next.hasNext();
    }

    private void readBatch() throws MailboxException {
        MessageRange range;
        switch (this.type) {
            default: {
                range = MessageRange.from((MessageUid)this.cursor);
                break;
            }
            case FROM: {
                range = MessageRange.from((MessageUid)this.cursor);
                break;
            }
            case ONE: {
                range = MessageRange.one((MessageUid)this.cursor);
                break;
            }
            case RANGE: {
                range = MessageRange.range((MessageUid)this.cursor, (MessageUid)this.to);
            }
        }
        this.next = this.mapper.findInMailbox(this.mailbox, range, this.ftype, this.batchSizeFromFetchType(this.ftype));
    }

    private int batchSizeFromFetchType(MessageMapper.FetchType fetchType) {
        switch (fetchType) {
            case Metadata: {
                return this.batchSizes.getFetchMetadata();
            }
            case Headers: {
                return this.batchSizes.getFetchHeaders();
            }
            case Body: {
                return this.batchSizes.getFetchBody();
            }
            case Full: {
                return this.batchSizes.getFetchFull();
            }
        }
        throw new RuntimeException("Unknown fetchTpe: " + (Object)((Object)fetchType));
    }

    public MessageResult next() {
        MessageResult result;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        MailboxMessage message = this.next.next();
        try {
            result = ResultUtils.loadMessageResult(message, this.group);
            this.cursor = result.getUid();
        }
        catch (MailboxException e) {
            result = new UnloadedMessageResult(message, e);
        }
        this.cursor = this.cursor.next();
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("Read only");
    }

    public MailboxException getException() {
        return this.exception;
    }

    private static final class UnloadedMessageResult
    implements MessageResult {
        private final MailboxException exception;
        private final Date internalDate;
        private final long size;
        private final MessageUid uid;
        private final Flags flags;
        private final MessageId messageId;
        private long modSeq = -1L;
        private final MailboxId mailboxId;

        public UnloadedMessageResult(MailboxMessage message, MailboxException exception) {
            this.internalDate = message.getInternalDate();
            this.size = message.getFullContentOctets();
            this.uid = message.getUid();
            this.flags = message.createFlags();
            this.modSeq = message.getModSeq();
            this.mailboxId = message.getMailboxId();
            this.messageId = message.getMessageId();
            this.exception = exception;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }

        public Flags getFlags() {
            return this.flags;
        }

        public Content getFullContent() throws MailboxException {
            throw this.exception;
        }

        public Date getInternalDate() {
            return this.internalDate;
        }

        public Content getBody() throws MailboxException {
            throw this.exception;
        }

        public long getSize() {
            return this.size;
        }

        public MessageUid getUid() {
            return this.uid;
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public int compareTo(MessageResult that) {
            return this.uid.compareTo(that.getUid());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.exception, this.internalDate, this.size, this.uid, this.flags, this.modSeq, this.messageId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UnloadedMessageResult) {
                UnloadedMessageResult that = (UnloadedMessageResult)obj;
                return this.size == that.size && this.uid.equals((Object)that.uid) && this.modSeq == that.modSeq && ((Object)((Object)this.exception)).equals((Object)that.exception) && this.internalDate.equals(that.internalDate) && this.flags.equals((Object)that.flags);
            }
            return false;
        }

        public Content getFullContent(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Iterator<MessageResult.Header> iterateHeaders(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Iterator<MessageResult.Header> iterateMimeHeaders(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Content getBody(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public Content getMimeBody(MessageResult.MimePath path) throws MailboxException {
            throw this.exception;
        }

        public MimeDescriptor getMimeDescriptor() throws MailboxException {
            throw this.exception;
        }

        public long getModSeq() {
            return this.modSeq;
        }

        public Headers getHeaders() throws MailboxException {
            throw this.exception;
        }

        public List<MessageAttachment> getAttachments() throws MailboxException {
            throw this.exception;
        }
    }
}

