/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.ReadOnlyException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.ImmutableMailboxMessage;
import org.apache.james.mailbox.store.MailboxMetaData;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MoveResult;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.StoreMailboxPath;
import org.apache.james.mailbox.store.StoreMessageResultIterator;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.quota.QuotaChecker;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.streaming.CountingInputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;
import org.apache.james.util.BodyOffsetInputStream;
import org.apache.james.util.IteratorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMessageManager
implements MessageManager {
    private static final MailboxCounters ZERO_MAILBOX_COUNTERS = MailboxCounters.builder().count(0L).unseen(0L).build();
    protected static final Flags MINIMAL_PERMANET_FLAGS = new Flags();
    private static final Logger LOG;
    private final EnumSet<MailboxManager.MessageCapabilities> messageCapabilities;
    private final Mailbox mailbox;
    private final MailboxEventDispatcher dispatcher;
    private final MailboxSessionMapperFactory mapperFactory;
    private final MessageSearchIndex index;
    private final StoreRightManager storeRightManager;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final MailboxPathLocker locker;
    private final MessageParser messageParser;
    private final MessageId.Factory messageIdFactory;
    private BatchSizes batchSizes = BatchSizes.defaultValues();
    private final ImmutableMailboxMessage.Factory immutableMailboxMessageFactory;

    public StoreMessageManager(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities, MailboxSessionMapperFactory mapperFactory, MessageSearchIndex index, MailboxEventDispatcher dispatcher, MailboxPathLocker locker, Mailbox mailbox, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, BatchSizes batchSizes, ImmutableMailboxMessage.Factory immutableMailboxMessageFactory, StoreRightManager storeRightManager) {
        this.messageCapabilities = messageCapabilities;
        this.mailbox = mailbox;
        this.dispatcher = dispatcher;
        this.mapperFactory = mapperFactory;
        this.index = index;
        this.locker = locker;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.messageParser = messageParser;
        this.messageIdFactory = messageIdFactory;
        this.batchSizes = batchSizes;
        this.immutableMailboxMessageFactory = immutableMailboxMessageFactory;
        this.storeRightManager = storeRightManager;
    }

    protected MessageId.Factory getMessageIdFactory() {
        return this.messageIdFactory;
    }

    protected MailboxPathLocker getLocker() {
        return this.locker;
    }

    protected MailboxEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Mailbox getMailboxEntity() throws MailboxException {
        return this.mailbox;
    }

    protected Flags getPermanentFlags(MailboxSession session) {
        return new Flags(MINIMAL_PERMANET_FLAGS);
    }

    public MailboxCounters getMailboxCounters(MailboxSession mailboxSession) throws MailboxException {
        if (this.storeRightManager.hasRight(this.mailbox, MailboxACL.Right.Read, mailboxSession)) {
            return this.mapperFactory.createMessageMapper(mailboxSession).getMailboxCounters(this.mailbox);
        }
        return ZERO_MAILBOX_COUNTERS;
    }

    protected Flags getSharedPermanentFlags(MailboxSession session) {
        return this.getPermanentFlags(session);
    }

    public boolean isModSeqPermanent(MailboxSession session) {
        return true;
    }

    public Iterator<MessageUid> expunge(MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath(), mailboxSession.getPathDelimiter());
        }
        Map<MessageUid, MessageMetaData> uids = this.deleteMarkedInMailbox(set, mailboxSession);
        this.dispatcher.expunged(mailboxSession, uids, this.getMailboxEntity());
        return uids.keySet().iterator();
    }

    public ComposedMessageId appendMessage(MessageManager.AppendCommand appendCommand, MailboxSession session) throws MailboxException {
        return this.appendMessage(appendCommand.getMsgIn(), appendCommand.getInternalDate(), session, appendCommand.isRecent(), appendCommand.getFlags());
    }

    public ComposedMessageId appendMessage(InputStream msgIn, Date internalDate, MailboxSession mailboxSession, boolean isRecent, Flags flagsToBeSet) throws MailboxException {
        ComposedMessageId composedMessageId;
        File file = null;
        TeeInputStream tmpMsgIn = null;
        BodyOffsetInputStream bIn = null;
        FileOutputStream out = null;
        SharedFileInputStream contentIn = null;
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath(), mailboxSession.getPathDelimiter());
        }
        try {
            Flags flags;
            String boundary;
            String subType;
            String mediaType;
            file = File.createTempFile("imap", ".msg");
            out = new FileOutputStream(file);
            tmpMsgIn = new TeeInputStream(msgIn, (OutputStream)out);
            bIn = new BodyOffsetInputStream((InputStream)tmpMsgIn);
            MimeTokenStream parser = new MimeTokenStream(MimeConfig.PERMISSIVE, (BodyDescriptorBuilder)new DefaultBodyDescriptorBuilder());
            parser.setRecursionMode(RecursionMode.M_NO_RECURSE);
            parser.parse((InputStream)bIn);
            HeaderImpl header = new HeaderImpl();
            EntityState next = parser.next();
            while (next != EntityState.T_BODY && next != EntityState.T_END_OF_STREAM && next != EntityState.T_START_MULTIPART) {
                if (next == EntityState.T_FIELD) {
                    header.addField(parser.getField());
                }
                next = parser.next();
            }
            MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)parser.getBodyDescriptor();
            PropertyBuilder propertyBuilder = new PropertyBuilder();
            String mediaTypeFromHeader = descriptor.getMediaType();
            if (mediaTypeFromHeader == null) {
                mediaType = "text";
                subType = "plain";
            } else {
                mediaType = mediaTypeFromHeader;
                subType = descriptor.getSubType();
            }
            propertyBuilder.setMediaType(mediaType);
            propertyBuilder.setSubType(subType);
            propertyBuilder.setContentID(descriptor.getContentId());
            propertyBuilder.setContentDescription(descriptor.getContentDescription());
            propertyBuilder.setContentLocation(descriptor.getContentLocation());
            propertyBuilder.setContentMD5(descriptor.getContentMD5Raw());
            propertyBuilder.setContentTransferEncoding(descriptor.getTransferEncoding());
            propertyBuilder.setContentLanguage(descriptor.getContentLanguage());
            propertyBuilder.setContentDispositionType(descriptor.getContentDispositionType());
            propertyBuilder.setContentDispositionParameters(descriptor.getContentDispositionParameters());
            propertyBuilder.setContentTypeParameters(descriptor.getContentTypeParameters());
            String codeset = descriptor.getCharset();
            if (codeset == null) {
                if ("TEXT".equalsIgnoreCase(mediaType)) {
                    propertyBuilder.setCharset("us-ascii");
                }
            } else {
                propertyBuilder.setCharset(codeset);
            }
            if ((boundary = descriptor.getBoundary()) != null) {
                propertyBuilder.setBoundary(boundary);
            }
            if ("text".equalsIgnoreCase(mediaType)) {
                CountingInputStream bodyStream = new CountingInputStream(parser.getInputStream());
                bodyStream.readAll();
                long lines = bodyStream.getLineCount();
                bodyStream.close();
                next = parser.next();
                if (next == EntityState.T_EPILOGUE) {
                    CountingInputStream epilogueStream = new CountingInputStream(parser.getInputStream());
                    epilogueStream.readAll();
                    lines += (long)epilogueStream.getLineCount();
                    epilogueStream.close();
                }
                propertyBuilder.setTextualLineCount(lines);
            }
            if (flagsToBeSet == null) {
                flags = new Flags();
            } else {
                flags = flagsToBeSet;
                this.trimFlags(flags, mailboxSession);
            }
            if (isRecent) {
                flags.add(Flags.Flag.RECENT);
            }
            if (internalDate == null) {
                internalDate = new Date();
            }
            byte[] discard = new byte[4096];
            while (tmpMsgIn.read(discard) != -1) {
            }
            int bodyStartOctet = (int)bIn.getBodyStartOffset();
            if (bodyStartOctet == -1) {
                bodyStartOctet = 0;
            }
            contentIn = new SharedFileInputStream(file);
            int size = (int)file.length();
            List<MessageAttachment> attachments = this.extractAttachments(contentIn);
            propertyBuilder.setHasAttachment(this.hasNonInlinedAttachment(attachments));
            MailboxMessage message = this.createMessage(internalDate, size, bodyStartOctet, (SharedInputStream)contentIn, flags, propertyBuilder, attachments);
            new QuotaChecker(this.quotaManager, this.quotaRootResolver, this.mailbox).tryAddition(1L, size);
            composedMessageId = (ComposedMessageId)this.locker.executeWithLock(mailboxSession, this.getMailboxPath(), () -> {
                MessageMetaData data = this.appendMessageToStore(message, attachments, mailboxSession);
                Mailbox mailbox = this.getMailboxEntity();
                MailboxMessage copy = this.copyMessage(message);
                this.dispatcher.added(mailboxSession, mailbox, copy);
                return new ComposedMessageId(mailbox.getMailboxId(), data.getMessageId(), data.getUid());
            }, true);
        }
        catch (IOException | MimeException e) {
            try {
                throw new MailboxException("Unable to parse message", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bIn);
                IOUtils.closeQuietly(tmpMsgIn);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(contentIn);
                if (file == null || !file.delete()) {
                    // empty if block
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bIn);
        IOUtils.closeQuietly((InputStream)tmpMsgIn);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)contentIn);
        if (file == null || !file.delete()) {
            // empty if block
        }
        return composedMessageId;
    }

    private boolean hasNonInlinedAttachment(List<MessageAttachment> attachments) {
        return attachments.stream().anyMatch(messageAttachment -> !messageAttachment.isInlinedWithCid());
    }

    private List<MessageAttachment> extractAttachments(SharedFileInputStream contentIn) {
        try {
            return this.messageParser.retrieveAttachments((InputStream)contentIn);
        }
        catch (Exception e) {
            LOG.warn("Error while parsing mail's attachments: {}", (Object)e.getMessage(), (Object)e);
            return ImmutableList.of();
        }
    }

    protected MailboxMessage createMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, List<MessageAttachment> attachments) throws MailboxException {
        return new SimpleMailboxMessage(this.messageIdFactory.generate(), internalDate, size, bodyStartOctet, content, flags, propertyBuilder, this.getMailboxEntity().getMailboxId(), attachments);
    }

    private MailboxMessage copyMessage(MailboxMessage message) throws MailboxException {
        return SimpleMailboxMessage.from(message).mailboxId(message.getMailboxId()).uid(message.getUid()).modseq(message.getModSeq()).build();
    }

    public boolean isWriteable(MailboxSession session) throws MailboxException {
        return this.storeRightManager.isReadWrite(session, this.mailbox, this.getSharedPermanentFlags(session));
    }

    public MessageManager.MetaData getMetaData(boolean resetRecent, MailboxSession mailboxSession, MessageManager.MetaData.FetchGroup fetchGroup) throws MailboxException {
        ArrayList<MessageUid> recent;
        MessageUid firstUnseen;
        long messageCount;
        long unseenCount;
        MailboxACL resolvedAcl = this.storeRightManager.getResolvedMailboxACL(this.mailbox, mailboxSession);
        boolean hasReadRight = this.storeRightManager.hasRight(this.mailbox, MailboxACL.Right.Read, mailboxSession);
        if (!hasReadRight) {
            return MailboxMetaData.sensibleInformationFree(resolvedAcl, this.getMailboxEntity().getUidValidity(), this.isWriteable(mailboxSession), this.isModSeqPermanent(mailboxSession));
        }
        Flags permanentFlags = this.getPermanentFlags(mailboxSession);
        long uidValidity = this.getMailboxEntity().getUidValidity();
        MessageUid uidNext = this.mapperFactory.getMessageMapper(mailboxSession).getLastUid(this.mailbox).map(MessageUid::next).orElse(MessageUid.MIN_VALUE);
        long highestModSeq = this.mapperFactory.getMessageMapper(mailboxSession).getHighestModSeq(this.mailbox);
        switch (fetchGroup) {
            case UNSEEN_COUNT: {
                unseenCount = this.countUnseenMessagesInMailbox(mailboxSession);
                messageCount = this.getMessageCount(mailboxSession);
                firstUnseen = null;
                recent = this.recent(resetRecent, mailboxSession);
                break;
            }
            case FIRST_UNSEEN: {
                firstUnseen = this.findFirstUnseenMessageUid(mailboxSession);
                messageCount = this.getMessageCount(mailboxSession);
                unseenCount = 0L;
                recent = this.recent(resetRecent, mailboxSession);
                break;
            }
            case NO_UNSEEN: {
                firstUnseen = null;
                unseenCount = 0L;
                messageCount = this.getMessageCount(mailboxSession);
                recent = this.recent(resetRecent, mailboxSession);
                break;
            }
            default: {
                firstUnseen = null;
                unseenCount = 0L;
                messageCount = -1L;
                if (resetRecent) {
                    this.recent(resetRecent, mailboxSession);
                }
                recent = new ArrayList();
            }
        }
        return new MailboxMetaData(recent, permanentFlags, uidValidity, uidNext, highestModSeq, messageCount, unseenCount, firstUnseen, this.isWriteable(mailboxSession), this.isModSeqPermanent(mailboxSession), resolvedAcl);
    }

    private void trimFlags(Flags flags, MailboxSession session) {
        Flags.Flag[] systemFlags;
        Flags permFlags = this.getPermanentFlags(session);
        for (Flags.Flag f : systemFlags = flags.getSystemFlags()) {
            if (f == Flags.Flag.RECENT || permFlags.contains(f)) continue;
            flags.remove(f);
        }
        if (!permFlags.contains(Flags.Flag.USER)) {
            String[] uFlags;
            for (String uFlag : uFlags = flags.getUserFlags()) {
                if (permFlags.contains(uFlag)) continue;
                flags.remove(uFlag);
            }
        }
    }

    public Map<MessageUid, Flags> setFlags(Flags flags, MessageManager.FlagsUpdateMode flagsUpdateMode, MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath(), mailboxSession.getPathDelimiter());
        }
        TreeMap<MessageUid, Flags> newFlagsByUid = new TreeMap<MessageUid, Flags>();
        this.trimFlags(flags, mailboxSession);
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        Iterator it = messageMapper.execute(() -> messageMapper.updateFlags(this.getMailboxEntity(), new FlagsUpdateCalculator(flags, flagsUpdateMode), set));
        TreeMap<MessageUid, UpdatedFlags> uFlags = new TreeMap<MessageUid, UpdatedFlags>();
        while (it.hasNext()) {
            UpdatedFlags flag = (UpdatedFlags)it.next();
            newFlagsByUid.put(flag.getUid(), flag.getNewFlags());
            uFlags.put(flag.getUid(), flag);
        }
        this.dispatcher.flagsUpdated(mailboxSession, new ArrayList<MessageUid>(uFlags.keySet()), this.getMailboxEntity(), new ArrayList<UpdatedFlags>(uFlags.values()));
        return newFlagsByUid;
    }

    public List<MessageRange> copyTo(MessageRange set, StoreMessageManager toMailbox, MailboxSession session) throws MailboxException {
        if (!toMailbox.isWriteable(session)) {
            throw new ReadOnlyException((MailboxPath)new StoreMailboxPath(toMailbox.getMailboxEntity()), session.getPathDelimiter());
        }
        return (List)this.locker.executeWithLock(session, (MailboxPath)new StoreMailboxPath(toMailbox.getMailboxEntity()), () -> {
            SortedMap<MessageUid, MessageMetaData> copiedUids = this.copy(set, toMailbox, session);
            return MessageRange.toRanges(new ArrayList<MessageUid>(copiedUids.keySet()));
        }, true);
    }

    public List<MessageRange> moveTo(MessageRange set, StoreMessageManager toMailbox, MailboxSession session) throws MailboxException {
        if (!this.isWriteable(session)) {
            throw new ReadOnlyException(this.getMailboxPath(), session.getPathDelimiter());
        }
        if (!toMailbox.isWriteable(session)) {
            throw new ReadOnlyException((MailboxPath)new StoreMailboxPath(toMailbox.getMailboxEntity()), session.getPathDelimiter());
        }
        return (List)this.locker.executeWithLock(session, (MailboxPath)new StoreMailboxPath(toMailbox.getMailboxEntity()), () -> {
            SortedMap<MessageUid, MessageMetaData> movedUids = this.move(set, toMailbox, session);
            return MessageRange.toRanges(new ArrayList<MessageUid>(movedUids.keySet()));
        }, true);
    }

    protected MessageMetaData appendMessageToStore(MailboxMessage message, List<MessageAttachment> messageAttachments, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return this.mapperFactory.getMessageMapper(session).execute(() -> {
            this.storeAttachment(message, messageAttachments, session);
            return messageMapper.add(this.getMailboxEntity(), message);
        });
    }

    protected void storeAttachment(MailboxMessage message, List<MessageAttachment> messageAttachments, MailboxSession session) throws MailboxException {
    }

    public long getMessageCount(MailboxSession mailboxSession) throws MailboxException {
        return this.mapperFactory.getMessageMapper(mailboxSession).countMessagesInMailbox(this.getMailboxEntity());
    }

    public MessageResultIterator getMessages(MessageRange set, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return new StoreMessageResultIterator(messageMapper, this.mailbox, set, this.batchSizes, fetchGroup);
    }

    protected List<MessageUid> recent(boolean reset, MailboxSession mailboxSession) throws MailboxException {
        if (reset && !this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath(), mailboxSession.getPathDelimiter());
        }
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return messageMapper.execute(() -> {
            List<MessageUid> members = messageMapper.findRecentMessageUidsInMailbox(this.getMailboxEntity());
            List ranges = MessageRange.toRanges(members);
            for (MessageRange range : ranges) {
                if (!reset) continue;
                messageMapper.updateFlags(this.getMailboxEntity(), new FlagsUpdateCalculator(new Flags(Flags.Flag.RECENT), MessageManager.FlagsUpdateMode.REMOVE), range);
            }
            return members;
        });
    }

    protected Map<MessageUid, MessageMetaData> deleteMarkedInMailbox(MessageRange range, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.execute(() -> messageMapper.expungeMarkedForDeletionInMailbox(this.getMailboxEntity(), range));
    }

    public Iterator<MessageUid> search(SearchQuery query, MailboxSession mailboxSession) throws MailboxException {
        if (query.equals((Object)new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()}))) {
            return this.listAllMessageUids(mailboxSession);
        }
        return this.index.search(mailboxSession, this.getMailboxEntity(), query);
    }

    private Iterator<MessageMetaData> copy(Iterator<MailboxMessage> originalRows, MailboxSession session) throws MailboxException {
        ArrayList<MessageMetaData> copiedRows = new ArrayList<MessageMetaData>();
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        while (originalRows.hasNext()) {
            MailboxMessage originalMessage = originalRows.next();
            new QuotaChecker(this.quotaManager, this.quotaRootResolver, this.mailbox).tryAddition(1L, originalMessage.getFullContentOctets());
            MessageMetaData data = messageMapper.execute(() -> messageMapper.copy(this.getMailboxEntity(), originalMessage));
            this.dispatcher.added(session, this.getMailboxEntity(), this.immutableMailboxMessageFactory.from(this.getMailboxEntity().getMailboxId(), originalMessage));
            copiedRows.add(data);
        }
        return copiedRows.iterator();
    }

    private MoveResult move(Iterator<MailboxMessage> originalRows, MailboxSession session) throws MailboxException {
        ArrayList<MessageMetaData> movedRows = new ArrayList<MessageMetaData>();
        ArrayList<SimpleMessageMetaData> originalRowsCopy = new ArrayList<SimpleMessageMetaData>();
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        while (originalRows.hasNext()) {
            MailboxMessage originalMessage = originalRows.next();
            originalRowsCopy.add(new SimpleMessageMetaData(originalMessage));
            MessageMetaData data = messageMapper.execute(() -> messageMapper.move(this.getMailboxEntity(), originalMessage));
            movedRows.add(data);
        }
        return new MoveResult(movedRows.iterator(), originalRowsCopy.iterator());
    }

    private SortedMap<MessageUid, MessageMetaData> copy(MessageRange set, StoreMessageManager to, MailboxSession session) throws MailboxException {
        IteratorWrapper originalRows = new IteratorWrapper(this.retrieveOriginalRows(set, session));
        SortedMap<MessageUid, MessageMetaData> copiedUids = this.collectMetadata(to.copy((Iterator<MailboxMessage>)originalRows, session));
        ImmutableMap.Builder messagesMap = ImmutableMap.builder();
        for (MailboxMessage message : originalRows.getEntriesSeen()) {
            messagesMap.put((Object)message.getUid(), (Object)this.immutableMailboxMessageFactory.from(to.getMailboxEntity().getMailboxId(), message));
        }
        this.dispatcher.added(session, copiedUids, to.getMailboxEntity(), (Map<MessageUid, MailboxMessage>)messagesMap.build());
        this.dispatcher.moved(session, MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.getMailboxEntity().getMailboxId()}).targetMailboxIds(new MailboxId[]{to.getMailboxEntity().getMailboxId(), this.getMailboxEntity().getMailboxId()}).build(), (Map<MessageUid, MailboxMessage>)messagesMap.build());
        return copiedUids;
    }

    private SortedMap<MessageUid, MessageMetaData> move(MessageRange set, StoreMessageManager to, MailboxSession session) throws MailboxException {
        IteratorWrapper originalRows = new IteratorWrapper(this.retrieveOriginalRows(set, session));
        MoveResult moveResult = to.move((Iterator<MailboxMessage>)originalRows, session);
        SortedMap<MessageUid, MessageMetaData> moveUids = this.collectMetadata(moveResult.getMovedMessages());
        ImmutableMap.Builder messagesMap = ImmutableMap.builder();
        for (MailboxMessage message : originalRows.getEntriesSeen()) {
            messagesMap.put((Object)message.getUid(), (Object)this.immutableMailboxMessageFactory.from(to.getMailboxEntity().getMailboxId(), message));
        }
        this.dispatcher.added(session, moveUids, to.getMailboxEntity(), (Map<MessageUid, MailboxMessage>)messagesMap.build());
        this.dispatcher.expunged(session, this.collectMetadata(moveResult.getOriginalMessages()), this.getMailboxEntity());
        this.dispatcher.moved(session, MessageMoves.builder().previousMailboxIds(new MailboxId[]{this.getMailboxEntity().getMailboxId()}).targetMailboxIds(new MailboxId[]{to.getMailboxEntity().getMailboxId()}).build(), (Map<MessageUid, MailboxMessage>)messagesMap.build());
        return moveUids;
    }

    private Iterator<MailboxMessage> retrieveOriginalRows(MessageRange set, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.findInMailbox(this.mailbox, set, MessageMapper.FetchType.Full, -1);
    }

    private SortedMap<MessageUid, MessageMetaData> collectMetadata(Iterator<MessageMetaData> ids) {
        TreeMap<MessageUid, MessageMetaData> copiedMessages = new TreeMap<MessageUid, MessageMetaData>();
        while (ids.hasNext()) {
            MessageMetaData data = ids.next();
            copiedMessages.put(data.getUid(), data);
        }
        return copiedMessages;
    }

    protected long countUnseenMessagesInMailbox(MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.countUnseenMessagesInMailbox(this.getMailboxEntity());
    }

    protected MessageUid findFirstUnseenMessageUid(MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.findFirstUnseenMessageUid(this.getMailboxEntity());
    }

    public MailboxId getId() {
        return this.mailbox.getMailboxId();
    }

    public MailboxPath getMailboxPath() throws MailboxException {
        return new StoreMailboxPath(this.getMailboxEntity());
    }

    public Flags getApplicableFlags(MailboxSession session) throws MailboxException {
        return this.mapperFactory.getMessageMapper(session).getApplicableFlag(this.mailbox);
    }

    private Iterator<MessageUid> listAllMessageUids(MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.execute(() -> messageMapper.listAllMessageUids(this.mailbox));
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return this.messageCapabilities;
    }

    static {
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.ANSWERED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DELETED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DRAFT);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.FLAGGED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.SEEN);
        LOG = LoggerFactory.getLogger(StoreMessageManager.class);
    }
}

