/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionIdGenerator;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.StandardMailboxMetaDataComparator;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.NotAdminException;
import org.apache.james.mailbox.exception.UserDoesNotExistException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.ImmutableMailboxMessage;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageBatcher;
import org.apache.james.mailbox.store.RandomMailboxSessionIdGenerator;
import org.apache.james.mailbox.store.SimpleMailboxMetaData;
import org.apache.james.mailbox.store.SimpleMailboxSession;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.MailboxAnnotationListener;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.NoQuotaManager;
import org.apache.james.mailbox.store.quota.QuotaUpdater;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SimpleMessageSearchIndex;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMailboxManager
implements MailboxManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMailboxManager.class);
    public static final char SQL_WILDCARD_CHAR = '%';
    public static final EnumSet<MailboxManager.MessageCapabilities> DEFAULT_NO_MESSAGE_CAPABILITIES = EnumSet.noneOf(MailboxManager.MessageCapabilities.class);
    private final MailboxEventDispatcher dispatcher;
    private final DelegatingMailboxListener delegatingListener;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final Authenticator authenticator;
    private final MailboxAnnotationManager annotationManager;
    private Authorizator authorizator;
    private final StoreRightManager storeRightManager;
    private static final SecureRandom RANDOM = new SecureRandom();
    private MessageBatcher copyBatcher;
    private MessageBatcher moveBatcher;
    private final MailboxPathLocker locker;
    private MessageSearchIndex index;
    private MailboxSessionIdGenerator idGenerator;
    private QuotaManager quotaManager;
    private QuotaRootResolver quotaRootResolver;
    private QuotaUpdater quotaUpdater;
    private BatchSizes batchSizes = BatchSizes.defaultValues();
    private final MessageParser messageParser;
    private final MessageId.Factory messageIdFactory;
    private final ImmutableMailboxMessage.Factory immutableMailboxMessageFactory;

    @Inject
    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MessageParser messageParser, MessageId.Factory messageIdFactory, MailboxAnnotationManager annotationManager, MailboxEventDispatcher mailboxEventDispatcher, DelegatingMailboxListener delegatingListener, StoreRightManager storeRightManager) {
        Preconditions.checkNotNull((Object)delegatingListener);
        Preconditions.checkNotNull((Object)mailboxEventDispatcher);
        Preconditions.checkNotNull((Object)mailboxSessionMapperFactory);
        this.annotationManager = annotationManager;
        this.authenticator = authenticator;
        this.authorizator = authorizator;
        this.locker = locker;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.messageParser = messageParser;
        this.messageIdFactory = messageIdFactory;
        this.delegatingListener = delegatingListener;
        this.dispatcher = mailboxEventDispatcher;
        this.immutableMailboxMessageFactory = new ImmutableMailboxMessage.Factory();
        this.storeRightManager = storeRightManager;
    }

    public MessageId.Factory getMessageIdFactory() {
        return this.messageIdFactory;
    }

    public void setMailboxSessionIdGenerator(MailboxSessionIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setQuotaManager(QuotaManager quotaManager) {
        this.quotaManager = quotaManager;
    }

    public void setQuotaRootResolver(QuotaRootResolver quotaRootResolver) {
        this.quotaRootResolver = quotaRootResolver;
    }

    public void setQuotaUpdater(QuotaUpdater quotaUpdater) {
        this.quotaUpdater = quotaUpdater;
    }

    public void setCopyBatchSize(BatchSizes batchSizes) {
        this.copyBatcher = new MessageBatcher(batchSizes.getCopyBatchSize());
    }

    public void setMoveBatchSize(BatchSizes batchSizes) {
        this.moveBatcher = new MessageBatcher(batchSizes.getMoveBatchSize());
    }

    public void setBatchSizes(BatchSizes batchSizes) {
        this.batchSizes = batchSizes;
    }

    public BatchSizes getBatchSizes() {
        return this.batchSizes;
    }

    public ImmutableMailboxMessage.Factory getImmutableMailboxMessageFactory() {
        return this.immutableMailboxMessageFactory;
    }

    @PostConstruct
    public void init() throws MailboxException {
        if (this.idGenerator == null) {
            this.idGenerator = new RandomMailboxSessionIdGenerator();
        }
        MailboxSession session = this.createSystemSession("storeMailboxManager");
        if (this.index == null) {
            this.index = new SimpleMessageSearchIndex(this.mailboxSessionMapperFactory, this.mailboxSessionMapperFactory, new DefaultTextExtractor());
        }
        if (this.index instanceof ListeningMessageSearchIndex) {
            this.addGlobalListener((MailboxListener)this.index, session);
        }
        if (this.quotaManager == null) {
            this.quotaManager = new NoQuotaManager();
        }
        if (this.quotaRootResolver == null) {
            this.quotaRootResolver = new DefaultUserQuotaRootResolver(this.mailboxSessionMapperFactory);
        }
        if (this.quotaUpdater != null && this.quotaUpdater instanceof MailboxListener) {
            this.addGlobalListener((MailboxListener)this.quotaUpdater, session);
        }
        if (this.copyBatcher == null) {
            this.copyBatcher = new MessageBatcher(0);
        }
        if (this.moveBatcher == null) {
            this.moveBatcher = new MessageBatcher(0);
        }
        if (this.hasCapability(MailboxManager.MailboxCapabilities.Annotation)) {
            this.addGlobalListener(new MailboxAnnotationListener(this.mailboxSessionMapperFactory), session);
        }
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return EnumSet.noneOf(MailboxManager.MailboxCapabilities.class);
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return DEFAULT_NO_MESSAGE_CAPABILITIES;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedSearchCapabilities() {
        return this.index.getSupportedCapabilities(this.getSupportedMessageCapabilities());
    }

    public DelegatingMailboxListener getDelegationListener() {
        return this.delegatingListener;
    }

    public MessageSearchIndex getMessageSearchIndex() {
        return this.index;
    }

    public QuotaRootResolver getQuotaRootResolver() {
        return this.quotaRootResolver;
    }

    public QuotaManager getQuotaManager() {
        return this.quotaManager;
    }

    public MailboxEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }

    public MailboxSessionMapperFactory getMapperFactory() {
        return this.mailboxSessionMapperFactory;
    }

    public MailboxPathLocker getLocker() {
        return this.locker;
    }

    protected StoreRightManager getStoreRightManager() {
        return this.storeRightManager;
    }

    public MessageParser getMessageParser() {
        return this.messageParser;
    }

    public void setMessageSearchIndex(MessageSearchIndex index) {
        this.index = index;
    }

    protected int randomUidValidity() {
        return Math.abs(RANDOM.nextInt());
    }

    public MailboxSession createSystemSession(String userName) {
        return this.createSession(userName, null, MailboxSession.SessionType.System);
    }

    protected MailboxSession createSession(String userName, String password, MailboxSession.SessionType type) {
        return new SimpleMailboxSession(this.randomId(), userName, password, new ArrayList<Locale>(), this.getDelimiter(), type);
    }

    protected long randomId() {
        return this.idGenerator.nextId();
    }

    public char getDelimiter() {
        return '.';
    }

    private boolean isValidLogin(String userid, String passwd) throws MailboxException {
        return this.authenticator.isAuthentic(userid, passwd);
    }

    public MailboxSession login(String userid, String passwd) throws MailboxException {
        if (this.isValidLogin(userid, passwd)) {
            return this.createSession(userid, passwd, MailboxSession.SessionType.User);
        }
        throw new BadCredentialsException();
    }

    public MailboxSession loginAsOtherUser(String adminUserid, String passwd, String otherUserId) throws MailboxException {
        if (!this.isValidLogin(adminUserid, passwd)) {
            throw new BadCredentialsException();
        }
        Authorizator.AuthorizationState authorizationState = this.authorizator.canLoginAsOtherUser(adminUserid, otherUserId);
        switch (authorizationState) {
            case ALLOWED: {
                return this.createSystemSession(otherUserId);
            }
            case NOT_ADMIN: {
                throw new NotAdminException();
            }
            case UNKNOWN_USER: {
                throw new UserDoesNotExistException(otherUserId);
            }
        }
        throw new RuntimeException("Unknown AuthorizationState " + (Object)((Object)authorizationState));
    }

    public void logout(MailboxSession session, boolean force) throws MailboxException {
        if (session != null) {
            session.close();
        }
    }

    protected StoreMessageManager createMessageManager(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return new StoreMessageManager(DEFAULT_NO_MESSAGE_CAPABILITIES, this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventDispatcher(), this.getLocker(), mailbox, this.getQuotaManager(), this.getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.getBatchSizes(), this.getImmutableMailboxMessageFactory(), this.getStoreRightManager());
    }

    protected Mailbox doCreateMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return new SimpleMailbox(mailboxPath, this.randomUidValidity());
    }

    public MessageManager getMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailboxRow = mapper.findMailboxByPath(mailboxPath);
        if (mailboxRow == null) {
            LOGGER.info("Mailbox '{}' not found.", (Object)mailboxPath);
            throw new MailboxNotFoundException(mailboxPath);
        }
        LOGGER.debug("Loaded mailbox {}", (Object)mailboxPath);
        return this.createMessageManager(mailboxRow, session);
    }

    public MessageManager getMailbox(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailboxRow = mapper.findMailboxById(mailboxId);
        if (mailboxRow == null) {
            LOGGER.info("Mailbox '{}' not found.", (Object)mailboxId.serialize());
            throw new MailboxNotFoundException(mailboxId);
        }
        if (!this.assertUserHasAccessTo(mailboxRow, session)) {
            LOGGER.info("Mailbox '{}' does not belong to user '{}' but to '{}'", new Object[]{mailboxId.serialize(), session.getUser(), mailboxRow.getUser()});
            throw new MailboxNotFoundException(mailboxId);
        }
        LOGGER.debug("Loaded mailbox {}", (Object)mailboxId.serialize());
        return this.createMessageManager(mailboxRow, session);
    }

    private boolean assertUserHasAccessTo(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return this.belongsToCurrentUser(mailbox, session) || this.userHasLookupRightsOn(mailbox, session);
    }

    private boolean belongsToCurrentUser(Mailbox mailbox, MailboxSession session) {
        return mailbox.generateAssociatedPath().belongsTo(session);
    }

    private boolean userHasLookupRightsOn(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailbox, MailboxACL.Right.Lookup, session);
    }

    public Optional<MailboxId> createMailbox(MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxException {
        LOGGER.debug("createMailbox {}", (Object)mailboxPath);
        if (mailboxPath.getName().isEmpty()) {
            LOGGER.warn("Ignoring mailbox with empty name");
        } else {
            MailboxPath sanitizedMailboxPath = mailboxPath.sanitize(mailboxSession.getPathDelimiter());
            if (this.mailboxExists(sanitizedMailboxPath, mailboxSession)) {
                throw new MailboxExistsException(sanitizedMailboxPath.asString());
            }
            ArrayList mailboxIds = new ArrayList();
            for (MailboxPath mailbox : sanitizedMailboxPath.getHierarchyLevels(this.getDelimiter())) {
                this.locker.executeWithLock(mailboxSession, mailbox, () -> {
                    if (!this.mailboxExists(mailbox, mailboxSession)) {
                        Mailbox m = this.doCreateMailbox(mailbox, mailboxSession);
                        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
                        try {
                            mapper.execute(Mapper.toTransaction(() -> mailboxIds.add(mapper.save(m))));
                            this.dispatcher.mailboxAdded(mailboxSession, m);
                        }
                        catch (MailboxExistsException e) {
                            LOGGER.info("{} mailbox was created concurrently", (Object)m.generateAssociatedPath());
                        }
                    }
                    return null;
                }, true);
            }
            if (!mailboxIds.isEmpty()) {
                return Optional.ofNullable(Iterables.getLast(mailboxIds));
            }
        }
        return Optional.empty();
    }

    public void deleteMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        LOGGER.info("deleteMailbox {}", (Object)mailboxPath);
        this.assertIsOwner(session, mailboxPath);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.execute(() -> {
            Mailbox mailbox1 = mapper.findMailboxByPath(mailboxPath);
            if (mailbox1 == null) {
                throw new MailboxNotFoundException(mailboxPath);
            }
            SimpleMailbox m = new SimpleMailbox(mailbox1);
            mapper.delete(mailbox1);
            return m;
        });
        this.dispatcher.mailboxDeleted(session, mailbox);
    }

    public void renameMailbox(MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        LOGGER.debug("renameMailbox {} to {}", (Object)from, (Object)to);
        if (this.mailboxExists(to, session)) {
            throw new MailboxExistsException(to.toString());
        }
        this.assertIsOwner(session, from);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mapper.execute(Mapper.toTransaction(() -> this.doRenameMailbox(from, to, session, mapper)));
    }

    private void assertIsOwner(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxNotFoundException {
        if (!mailboxPath.belongsTo(mailboxSession)) {
            LOGGER.info("Mailbox {} does not belong to {}", (Object)mailboxPath.asString(), (Object)mailboxSession.getUser().getUserName());
            throw new MailboxNotFoundException(mailboxPath.asString());
        }
    }

    private void doRenameMailbox(MailboxPath from, MailboxPath to, MailboxSession session, MailboxMapper mapper) throws MailboxException {
        Mailbox mailbox = Optional.ofNullable(mapper.findMailboxByPath(from)).orElseThrow(() -> new MailboxNotFoundException(from));
        mailbox.setNamespace(to.getNamespace());
        mailbox.setUser(to.getUser());
        mailbox.setName(to.getName());
        mapper.save(mailbox);
        this.dispatcher.mailboxRenamed(session, from, mailbox);
        MailboxPath children = new MailboxPath(from.getNamespace(), from.getUser(), from.getName() + this.getDelimiter() + "%");
        this.locker.executeWithLock(session, children, () -> {
            List<Mailbox> subMailboxes = mapper.findMailboxWithPathLike(children);
            for (Mailbox sub : subMailboxes) {
                String subOriginalName = sub.getName();
                String subNewName = to.getName() + subOriginalName.substring(from.getName().length());
                MailboxPath fromPath = new MailboxPath(children, subOriginalName);
                sub.setName(subNewName);
                mapper.save(sub);
                this.dispatcher.mailboxRenamed(session, fromPath, sub);
                LOGGER.debug("Rename mailbox sub-mailbox {} to {}", (Object)subOriginalName, (Object)subNewName);
            }
            return null;
        }, true);
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    private List<MessageRange> copyMessages(MessageRange set, MailboxSession session, StoreMessageManager toMailbox, StoreMessageManager fromMailbox) throws MailboxException {
        return this.copyBatcher.batchMessages(set, messageRange -> fromMailbox.copyTo(messageRange, toMailbox, session));
    }

    public List<MessageRange> moveMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.moveBatcher.batchMessages(set, messageRange -> fromMailbox.moveTo(messageRange, toMailbox, session));
    }

    public List<MailboxMetaData> search(MailboxQuery mailboxExpression, MailboxSession session) throws MailboxException {
        return this.searchMailboxes(mailboxExpression, session, MailboxACL.Right.Lookup);
    }

    private List<MailboxMetaData> searchMailboxes(MailboxQuery mailboxExpression, MailboxSession session, MailboxACL.Right right) throws MailboxException {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Stream baseMailboxes = mailboxMapper.findMailboxWithPathLike(StoreMailboxManager.getPathLike(mailboxExpression, session)).stream();
        Stream<Mailbox> delegatedMailboxes = this.getDelegatedMailboxes(mailboxMapper, mailboxExpression, right, session);
        List mailboxes = (List)Stream.concat(baseMailboxes, delegatedMailboxes).distinct().filter((Predicate<Mailbox>)Throwing.predicate(mailbox -> this.storeRightManager.hasRight((Mailbox)mailbox, right, session))).collect(Guavate.toImmutableList());
        return (List)mailboxes.stream().filter(mailbox -> mailboxExpression.isPathMatch(mailbox.generateAssociatedPath())).map(mailbox -> this.toMailboxMetadata(session, mailboxes, (Mailbox)mailbox)).sorted((Comparator<SimpleMailboxMetaData>)new StandardMailboxMetaDataComparator()).collect(Guavate.toImmutableList());
    }

    @VisibleForTesting
    public static MailboxPath getPathLike(MailboxQuery mailboxQuery, MailboxSession mailboxSession) {
        MailboxNameExpression nameExpression = mailboxQuery.getMailboxNameExpression();
        String combinedName = nameExpression.getCombinedName().replace(nameExpression.getFreeWildcard(), '%').replace(nameExpression.getLocalWildcard(), '%') + '%';
        MailboxPath base = new MailboxPath(mailboxQuery.getNamespace().orElse("#private"), mailboxQuery.getUser().orElse(mailboxSession.getUser().getUserName()), combinedName);
        return new MailboxPath(base, combinedName);
    }

    private Stream<Mailbox> getDelegatedMailboxes(MailboxMapper mailboxMapper, MailboxQuery mailboxQuery, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        if (mailboxQuery.isPrivateMailboxes(session)) {
            return Stream.of(new Mailbox[0]);
        }
        return mailboxMapper.findNonPersonalMailboxes(session.getUser().getUserName(), right).stream();
    }

    private SimpleMailboxMetaData toMailboxMetadata(MailboxSession session, List<Mailbox> mailboxes, Mailbox mailbox) {
        return new SimpleMailboxMetaData(mailbox.generateAssociatedPath(), mailbox.getMailboxId(), this.getDelimiter(), this.computeChildren(session, mailboxes, mailbox), MailboxMetaData.Selectability.NONE);
    }

    private MailboxMetaData.Children computeChildren(MailboxSession session, List<Mailbox> potentialChildren, Mailbox mailbox) {
        if (this.hasChildIn(mailbox, potentialChildren, session)) {
            return MailboxMetaData.Children.HAS_CHILDREN;
        }
        return MailboxMetaData.Children.HAS_NO_CHILDREN;
    }

    private boolean hasChildIn(Mailbox parentMailbox, List<Mailbox> mailboxesWithPathLike, MailboxSession mailboxSession) {
        return mailboxesWithPathLike.stream().anyMatch(mailbox -> mailbox.isChildOf(parentMailbox, mailboxSession));
    }

    public List<MessageId> search(MultimailboxesSearchQuery expression, MailboxSession session, long limit) throws MailboxException {
        ImmutableSet wantedMailboxesId = (ImmutableSet)this.getInMailboxes((ImmutableSet<MailboxId>)expression.getInMailboxes(), session).filter(id -> !expression.getNotInMailboxes().contains(id)).collect(Guavate.toImmutableSet());
        return this.index.search(session, (Collection<MailboxId>)wantedMailboxesId, expression.getSearchQuery(), limit);
    }

    private Stream<MailboxId> getInMailboxes(ImmutableSet<MailboxId> inMailboxes, MailboxSession session) throws MailboxException {
        if (inMailboxes.isEmpty()) {
            return this.getAllReadableMailbox(session);
        }
        return this.getAllReadableMailbox(session).filter(arg_0 -> inMailboxes.contains(arg_0));
    }

    private Stream<MailboxId> getAllReadableMailbox(MailboxSession session) throws MailboxException {
        return this.searchMailboxes(MailboxQuery.builder().matchesAllMailboxNames().build(), session, MailboxACL.Right.Read).stream().map(MailboxMetaData::getId);
    }

    public boolean mailboxExists(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        try {
            MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
            mapper.findMailboxByPath(mailboxPath);
            return true;
        }
        catch (MailboxNotFoundException e) {
            return false;
        }
    }

    public void addListener(MailboxPath path, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.addListener(path, listener, session);
    }

    public void endProcessingRequest(MailboxSession session) {
        this.mailboxSessionMapperFactory.endProcessingRequest(session);
    }

    public void startProcessingRequest(MailboxSession session) {
    }

    public List<MailboxPath> list(MailboxSession session) throws MailboxException {
        return (List)this.mailboxSessionMapperFactory.getMailboxMapper(session).list().stream().map(Mailbox::generateAssociatedPath).collect(Guavate.toImmutableList());
    }

    public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.addGlobalListener(listener, session);
    }

    public void removeListener(MailboxPath mailboxPath, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.removeListener(mailboxPath, listener, session);
    }

    public void removeGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.removeGlobalListener(listener, session);
    }

    public boolean hasRight(MailboxPath mailboxPath, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxPath, right, session);
    }

    public boolean hasRight(MailboxId mailboxId, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.storeRightManager.hasRight(mailboxId, right, session);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.myRights(mailboxPath, session);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        return this.storeRightManager.myRights(mailboxId, session);
    }

    public MailboxACL.Rfc4314Rights[] listRights(MailboxPath mailboxPath, MailboxACL.EntryKey key, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, key, session);
    }

    public MailboxACL listRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.storeRightManager.listRights(mailboxPath, session);
    }

    public void applyRightsCommand(MailboxPath mailboxPath, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        this.storeRightManager.applyRightsCommand(mailboxPath, mailboxACLCommand, session);
    }

    public void setRights(MailboxPath mailboxPath, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxPath, mailboxACL, session);
    }

    public void setRights(MailboxId mailboxId, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.storeRightManager.setRights(mailboxId, mailboxACL, session);
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return this.annotationManager.getAllAnnotations(mailboxPath, session);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeys(mailboxPath, session, keys);
    }

    public void updateAnnotations(MailboxPath mailboxPath, MailboxSession session, List<MailboxAnnotation> mailboxAnnotations) throws MailboxException {
        this.annotationManager.updateAnnotations(mailboxPath, session, mailboxAnnotations);
    }

    public boolean hasCapability(MailboxManager.MailboxCapabilities capability) {
        return this.getSupportedMailboxCapabilities().contains(capability);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithOneDepth(mailboxPath, session, keys);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return this.annotationManager.getAnnotationsByKeysWithAllDepth(mailboxPath, session, keys);
    }

    public boolean hasChildren(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        return mapper.hasChildren(mailbox, session.getPathDelimiter());
    }
}

