/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mailbox.MailboxSession;

public class SimpleMailboxSession
implements MailboxSession,
MailboxSession.User {
    private final Collection<String> sharedSpaces;
    private final String otherUsersSpace;
    private final String personalSpace;
    private final long sessionId;
    private final String userName;
    private final String password;
    private boolean open = true;
    private final List<Locale> localePreferences;
    private final Map<Object, Object> attributes;
    private final char pathSeparator;
    private final MailboxSession.SessionType type;

    public SimpleMailboxSession(long sessionId, String userName, String password, List<Locale> localePreferences, char pathSeparator, MailboxSession.SessionType type) {
        this(sessionId, userName, password, localePreferences, new ArrayList<String>(), null, pathSeparator, type);
    }

    public SimpleMailboxSession(long sessionId, String userName, String password, List<Locale> localePreferences, List<String> sharedSpaces, String otherUsersSpace, char pathSeparator, MailboxSession.SessionType type) {
        this.sessionId = sessionId;
        this.userName = userName;
        this.password = password;
        this.otherUsersSpace = otherUsersSpace;
        this.sharedSpaces = sharedSpaces;
        this.type = type;
        this.personalSpace = otherUsersSpace == null && (sharedSpaces == null || sharedSpaces.isEmpty()) ? "" : "#private";
        this.localePreferences = localePreferences;
        this.attributes = new HashMap<Object, Object>();
        this.pathSeparator = pathSeparator;
    }

    public void close() {
        this.open = false;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String toString() {
        String TAB = " ";
        return "MailboxSession ( sessionId = " + this.sessionId + " " + "open = " + this.open + " " + " )";
    }

    public MailboxSession.User getUser() {
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getOtherUsersSpace() {
        return this.otherUsersSpace;
    }

    public String getPersonalSpace() {
        return this.personalSpace;
    }

    public Collection<String> getSharedSpaces() {
        return this.sharedSpaces;
    }

    public List<Locale> getLocalePreferences() {
        return this.localePreferences;
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public String getPassword() {
        return this.password;
    }

    public char getPathDelimiter() {
        return this.pathSeparator;
    }

    public MailboxSession.SessionType getType() {
        return this.type;
    }

    public boolean isSameUser(String username) {
        if (this.userName == null) {
            return username == null;
        }
        return this.userName.equalsIgnoreCase(username);
    }
}

