/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.FlagsFactory;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Property;

public class ImmutableMailboxMessage
implements MailboxMessage {
    private final MessageId messageId;
    private final Date internalDate;
    private final byte[] bodyContent;
    private final String mediaType;
    private final String subType;
    private final long bodyOctets;
    private final long fullContentOctets;
    private final long headerOctets;
    private final Long textualLineCount;
    private final byte[] headerContent;
    private final List<Property> properties;
    private final List<MessageAttachment> attachments;
    private final MailboxId mailboxId;
    private final MessageUid uid;
    private final long modSeq;
    private final boolean answered;
    private final boolean deleted;
    private final boolean draft;
    private final boolean flagged;
    private final boolean recent;
    private final boolean seen;
    private final String[] userFlags;

    private ImmutableMailboxMessage(MessageId messageId, Date internalDate, byte[] bodyContent, String mediaType, String subType, long bodyOctets, long fullContentOctets, long headerOctets, Long textualLineCount, byte[] headerContent, List<Property> properties, List<MessageAttachment> attachments, MailboxId mailboxId, MessageUid uid, long modSeq, boolean answered, boolean deleted, boolean draft, boolean flagged, boolean recent, boolean seen, String[] userFlags) {
        this.messageId = messageId;
        this.internalDate = internalDate;
        this.bodyContent = bodyContent;
        this.mediaType = mediaType;
        this.subType = subType;
        this.bodyOctets = bodyOctets;
        this.fullContentOctets = fullContentOctets;
        this.headerOctets = headerOctets;
        this.textualLineCount = textualLineCount;
        this.headerContent = headerContent;
        this.properties = properties;
        this.attachments = attachments;
        this.mailboxId = mailboxId;
        this.uid = uid;
        this.modSeq = modSeq;
        this.answered = answered;
        this.deleted = deleted;
        this.draft = draft;
        this.flagged = flagged;
        this.recent = recent;
        this.seen = seen;
        this.userFlags = userFlags;
    }

    @Override
    public ComposedMessageIdWithMetaData getComposedMessageIdWithMetaData() {
        return ComposedMessageIdWithMetaData.builder().modSeq(this.modSeq).flags(this.createFlags()).composedMessageId(new ComposedMessageId(this.mailboxId, this.getMessageId(), this.uid)).build();
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public Date getInternalDate() {
        return this.internalDate;
    }

    @Override
    public InputStream getBodyContent() {
        return new ByteArrayInputStream(this.bodyContent);
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    @Override
    public long getBodyOctets() {
        return this.bodyOctets;
    }

    @Override
    public long getFullContentOctets() {
        return this.fullContentOctets;
    }

    @Override
    public long getHeaderOctets() {
        return this.headerOctets;
    }

    @Override
    public Long getTextualLineCount() {
        return this.textualLineCount;
    }

    @Override
    public InputStream getHeaderContent() {
        return new ByteArrayInputStream(this.headerContent);
    }

    @Override
    public InputStream getFullContent() {
        return new SequenceInputStream(new ByteArrayInputStream(this.headerContent), new ByteArrayInputStream(this.bodyContent));
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<MessageAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    @Override
    public MessageUid getUid() {
        return this.uid;
    }

    @Override
    public long getModSeq() {
        return this.modSeq;
    }

    @Override
    public boolean isAnswered() {
        return this.answered;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public boolean isDraft() {
        return this.draft;
    }

    @Override
    public boolean isFlagged() {
        return this.flagged;
    }

    @Override
    public boolean isRecent() {
        return this.recent;
    }

    @Override
    public boolean isSeen() {
        return this.seen;
    }

    @Override
    public int compareTo(MailboxMessage o) {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    public void setUid(MessageUid uid) {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    public void setModSeq(long modSeq) {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    public void setFlags(Flags flags) {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    public Flags createFlags() {
        return FlagsFactory.createFlags(this, this.userFlags);
    }

    public static class Factory {
        public ImmutableMailboxMessage from(MailboxId mailboxId, MailboxMessage message) throws MailboxException {
            try {
                return new ImmutableMailboxMessage(message.getMessageId(), message.getInternalDate(), IOUtils.toByteArray((InputStream)message.getBodyContent()), message.getMediaType(), message.getSubType(), message.getBodyOctets(), message.getFullContentOctets(), message.getFullContentOctets() - message.getBodyOctets(), message.getTextualLineCount(), IOUtils.toByteArray((InputStream)message.getHeaderContent()), (List)ImmutableList.copyOf(message.getProperties()), (List)this.attachments(message), mailboxId, message.getUid(), message.getModSeq(), message.isAnswered(), message.isDeleted(), message.isDraft(), message.isFlagged(), message.isRecent(), message.isSeen(), message.createFlags().getUserFlags());
            }
            catch (IOException e) {
                throw new MailboxException("Unable to parse message", (Throwable)e);
            }
        }

        private ImmutableList<MessageAttachment> attachments(MailboxMessage message) {
            return ImmutableList.copyOf(message.getAttachments());
        }
    }
}

