/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageStringCodingException;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;
import org.msgpack.value.ValueVisitor;
import org.msgpack.value.impl.AbstractValue;

public class StringValueImpl
extends AbstractValue
implements StringValue {
    private final String value;

    public StringValueImpl(String string) {
        this.value = string;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public byte[] toByteArray() {
        return this.value.getBytes(MessagePack.UTF8);
    }

    @Override
    public MessageBuffer toMessageBuffer() {
        return MessageBuffer.wrap(this.toByteArray());
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.toMessageBuffer().toByteBuffer();
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packString(this.value);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitString(this);
    }

    @Override
    public StringValue toValue() {
        return ValueFactory.newString(this.value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isString()) {
            return false;
        }
        try {
            return value.asString().toString().equals(this.value);
        }
        catch (MessageStringCodingException messageStringCodingException) {
            return false;
        }
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

