/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.scanner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SpamAssassinResult {
    public static final String STATUS_MAIL_ATTRIBUTE_NAME = "org.apache.james.spamassassin.status";
    public static final String FLAG_MAIL_ATTRIBUTE_NAME = "org.apache.james.spamassassin.flag";
    public static final String NO_RESULT = "?";
    private final String hits;
    private final String requiredHits;
    private final Map<String, String> headersAsAttribute;

    public static SpamAssassinResult empty() {
        return SpamAssassinResult.asHam().hits(NO_RESULT).requiredHits(NO_RESULT).build();
    }

    public static Builder asSpam() {
        return new Builder(true);
    }

    public static Builder asHam() {
        return new Builder(false);
    }

    private SpamAssassinResult(String hits, String requiredHits, Map<String, String> headersAsAttribute) {
        this.hits = hits;
        this.requiredHits = requiredHits;
        this.headersAsAttribute = headersAsAttribute;
    }

    public String getHits() {
        return this.hits;
    }

    public String getRequiredHits() {
        return this.requiredHits;
    }

    public Map<String, String> getHeadersAsAttribute() {
        return this.headersAsAttribute;
    }

    public static class Builder {
        private String hits;
        private String requiredHits;
        private final boolean isSpam;

        private Builder(boolean isSpam) {
            this.isSpam = isSpam;
        }

        public Builder hits(String hits) {
            this.hits = hits;
            return this;
        }

        public Builder requiredHits(String requiredHits) {
            this.requiredHits = requiredHits;
            return this;
        }

        public SpamAssassinResult build() {
            Preconditions.checkNotNull((Object)this.hits);
            Preconditions.checkNotNull((Object)this.requiredHits);
            ImmutableMap.Builder headersAsAttribute = ImmutableMap.builder();
            if (this.isSpam) {
                headersAsAttribute.put((Object)SpamAssassinResult.FLAG_MAIL_ATTRIBUTE_NAME, (Object)"YES");
                headersAsAttribute.put((Object)SpamAssassinResult.STATUS_MAIL_ATTRIBUTE_NAME, (Object)("Yes, hits=" + this.hits + " required=" + this.requiredHits));
            } else {
                headersAsAttribute.put((Object)SpamAssassinResult.FLAG_MAIL_ATTRIBUTE_NAME, (Object)"NO");
                headersAsAttribute.put((Object)SpamAssassinResult.STATUS_MAIL_ATTRIBUTE_NAME, (Object)("No, hits=" + this.hits + " required=" + this.requiredHits));
            }
            return new SpamAssassinResult(this.hits, this.requiredHits, (Map)headersAsAttribute.build());
        }
    }
}

