/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.concurrency;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentTestRunner {
    public static final int DEFAULT_OPERATION_COUNT = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentTestRunner.class);
    private final int threadCount;
    private final int operationCount;
    private final CountDownLatch countDownLatch;
    private final BiConsumer biConsumer;
    private final ExecutorService executorService;
    private final List<Future<?>> futures;

    public static Builder builder() {
        return new Builder();
    }

    private ConcurrentTestRunner(int threadCount, int operationCount, BiConsumer biConsumer) {
        this.threadCount = threadCount;
        this.operationCount = operationCount;
        this.countDownLatch = new CountDownLatch(threadCount);
        this.biConsumer = biConsumer;
        this.executorService = Executors.newFixedThreadPool(threadCount);
        this.futures = new ArrayList();
    }

    public ConcurrentTestRunner run() {
        for (int i = 0; i < this.threadCount; ++i) {
            this.futures.add(this.executorService.submit(new ConcurrentRunnableTask(i, this.biConsumer)));
        }
        return this;
    }

    public ConcurrentTestRunner assertNoException() throws ExecutionException, InterruptedException {
        for (Future<?> future : this.futures) {
            future.get();
        }
        return this;
    }

    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        this.executorService.shutdown();
        return this.executorService.awaitTermination(time, unit);
    }

    private class ConcurrentRunnableTask
    implements Runnable {
        private final int threadNumber;
        private final BiConsumer biConsumer;
        private Exception exception;

        public ConcurrentRunnableTask(int threadNumber, BiConsumer biConsumer) {
            this.threadNumber = threadNumber;
            this.biConsumer = biConsumer;
        }

        @Override
        public void run() {
            this.exception = null;
            ConcurrentTestRunner.this.countDownLatch.countDown();
            for (int i = 0; i < ConcurrentTestRunner.this.operationCount; ++i) {
                try {
                    this.biConsumer.consume(this.threadNumber, i);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error caught during concurrent testing", (Throwable)e);
                    this.exception = e;
                }
            }
            if (this.exception != null) {
                throw new RuntimeException(this.exception);
            }
        }
    }

    public static interface BiConsumer {
        public void consume(int var1, int var2) throws Exception;
    }

    public static class Builder {
        private Optional<Integer> threadCount = Optional.empty();
        private Optional<Integer> operationCount = Optional.empty();

        public Builder threadCount(int threadCount) {
            Preconditions.checkArgument((threadCount > 0 ? 1 : 0) != 0, (Object)"Thread count should be strictly positive");
            this.threadCount = Optional.of(threadCount);
            return this;
        }

        public Builder operationCount(int operationCount) {
            Preconditions.checkArgument((operationCount > 0 ? 1 : 0) != 0, (Object)"Operation count should be strictly positive");
            this.operationCount = Optional.of(operationCount);
            return this;
        }

        public ConcurrentTestRunner build(BiConsumer operation) {
            Preconditions.checkState((boolean)this.threadCount.isPresent(), (Object)"'threadCount' is compulsory");
            Preconditions.checkNotNull((Object)operation);
            return new ConcurrentTestRunner(this.threadCount.get(), this.operationCount.orElse(1), operation);
        }
    }
}

