/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.pop3server.mailbox.MailboxAdapter;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.lib.POP3BeforeSMTPHelper;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPassCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassCmdHandler
extends AbstractPassCmdHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PassCmdHandler.class);
    private MailboxManager manager;

    @Inject
    public void setMailboxManager(@Named(value="mailboxmanager") MailboxManager manager) {
        this.manager = manager;
    }

    public Response onCommand(POP3Session session, Request request) {
        Response response = super.onCommand(session, request);
        if ("+OK".equals(response.getRetCode())) {
            POP3BeforeSMTPHelper.addIPAddress((String)session.getRemoteAddress().getAddress().getHostAddress());
        }
        return response;
    }

    protected Mailbox auth(POP3Session session, String username, String password) throws Exception {
        MailboxSession mSession = null;
        try {
            mSession = this.manager.login(session.getUser(), password);
            this.manager.startProcessingRequest(mSession);
            MailboxPath inbox = MailboxPath.inbox((MailboxSession)mSession);
            if (!this.manager.mailboxExists(inbox, mSession)) {
                Optional mailboxId = this.manager.createMailbox(inbox, mSession);
                LOGGER.info("Provisioning INBOX. {} created.", (Object)mailboxId);
            }
            MessageManager mailbox = this.manager.getMailbox(MailboxPath.inbox((MailboxSession)mSession), mSession);
            MailboxAdapter mailboxAdapter = new MailboxAdapter(this.manager, mailbox, mSession);
            return mailboxAdapter;
        }
        catch (BadCredentialsException e) {
            Mailbox mailbox = null;
            return mailbox;
        }
        catch (MailboxException e) {
            throw new IOException("Unable to access mailbox for user " + session.getUser(), e);
        }
        finally {
            if (mSession != null) {
                this.manager.endProcessingRequest(mSession);
            }
        }
    }
}

