/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api.handler;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;

public abstract class MultiLineHandler<S extends ProtocolSession>
implements LineHandler<S> {
    private static final String BUFFERED_LINES = "BUFFERED_LINES";

    @Override
    public Response onLine(S session, ByteBuffer line) {
        ArrayList<ByteBuffer> lines = (ArrayList<ByteBuffer>)session.getAttachment(BUFFERED_LINES, ProtocolSession.State.Transaction);
        if (lines == null) {
            lines = new ArrayList<ByteBuffer>();
            session.setAttachment(BUFFERED_LINES, lines, ProtocolSession.State.Transaction);
        }
        lines.add(line);
        if (this.isReady(session, line)) {
            return this.onLines(session, (Collection)session.setAttachment(BUFFERED_LINES, null, ProtocolSession.State.Transaction));
        }
        return null;
    }

    protected abstract boolean isReady(S var1, ByteBuffer var2);

    protected abstract Response onLines(S var1, Collection<ByteBuffer> var2);
}

