/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.util.MDCBuilder;
import org.jboss.netty.channel.ChannelHandlerContext;

public class ProtocolMDCContext {
    public static Closeable from(Protocol protocol, ChannelHandlerContext ctx) {
        return MDCBuilder.create().addContext(ProtocolMDCContext.from(ctx.getAttachment())).addContext("protocol", (Object)protocol.getName()).addContext("ip", (Object)ProtocolMDCContext.retrieveIp(ctx)).addContext("host", (Object)ProtocolMDCContext.retrieveHost(ctx)).build();
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        return remoteAddress.toString();
    }

    private static String retrieveHost(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getHostName();
        }
        return remoteAddress.toString();
    }

    private static MDCBuilder from(Object o) {
        return Optional.ofNullable(o).filter(object -> object instanceof ProtocolSession).map(object -> (ProtocolSession)object).map(protocolSession -> MDCBuilder.create().addContext("sessionId", (Object)protocolSession.getSessionID()).addContext("charset", (Object)protocolSession.getCharset().displayName()).addContext("user", (Object)protocolSession.getUser())).orElse(MDCBuilder.create());
    }
}

