/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.user;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.jcr.AbstractJCRScalingMapper;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.jcr.user.model.JCRSubscription;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;

public class JCRSubscriptionMapper
extends AbstractJCRScalingMapper
implements SubscriptionMapper {
    private static final String XPATH_LANGUAGE = "xpath";

    public JCRSubscriptionMapper(MailboxSessionJCRRepository repos, MailboxSession session, int scaling) {
        super(repos, session, scaling);
    }

    public void delete(Subscription subscription) throws SubscriptionException {
        JCRSubscription sub = (JCRSubscription)subscription;
        try {
            Node node = sub.getNode();
            if (node != null) {
                Property prop = node.getProperty("jamesMailbox:subscriptionMailboxes");
                Value[] values = prop.getValues();
                ArrayList<String> newValues = new ArrayList<String>();
                for (Value value : values) {
                    String m = value.getString();
                    if (m.equals(sub.getMailbox())) continue;
                    newValues.add(m);
                }
                if (!newValues.isEmpty()) {
                    prop.setValue(newValues.toArray(new String[newValues.size()]));
                } else {
                    prop.remove();
                }
            }
        }
        catch (PathNotFoundException node) {
        }
        catch (RepositoryException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    public Subscription findMailboxSubscriptionForUser(String user, String mailbox) throws SubscriptionException {
        try {
            String queryString = "/jcr:root/mailboxes//element(*,jamesMailbox:user)[@jamesMailbox:user='" + user + "'] AND [@" + "jamesMailbox:subscriptionMailboxes" + "='" + mailbox + "']";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
            NodeIterator nodeIt = result.getNodes();
            if (nodeIt.hasNext()) {
                return new JCRSubscription(nodeIt.nextNode(), mailbox);
            }
        }
        catch (PathNotFoundException queryString) {
        }
        catch (RepositoryException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
        return null;
    }

    public List<Subscription> findSubscriptionsForUser(String user) throws SubscriptionException {
        ArrayList<Subscription> subList = new ArrayList<Subscription>();
        try {
            String queryString = "/jcr:root/mailboxes//element(*,jamesMailbox:user)[@jamesMailbox:user='" + user + "']";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
            NodeIterator nodeIt = result.getNodes();
            while (nodeIt.hasNext()) {
                Value[] values;
                Node node = nodeIt.nextNode();
                if (!node.hasProperty("jamesMailbox:subscriptionMailboxes")) continue;
                for (Value value : values = node.getProperty("jamesMailbox:subscriptionMailboxes").getValues()) {
                    subList.add(new JCRSubscription(node, value.getString()));
                }
            }
        }
        catch (PathNotFoundException queryString) {
        }
        catch (RepositoryException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
        return subList;
    }

    public void save(Subscription subscription) throws SubscriptionException {
        String username = subscription.getUser();
        String mailbox = subscription.getMailbox();
        try {
            Node node = null;
            JCRSubscription sub = (JCRSubscription)this.findMailboxSubscriptionForUser(username, mailbox);
            if (sub == null) {
                node = JcrUtils.getOrAddNode((Node)this.getSession().getRootNode(), (String)"mailboxes");
                node = JcrUtils.getOrAddNode((Node)node, (String)Text.escapeIllegalJcrChars((String)"#private"));
                node = this.createUserPathStructure(node, Text.escapeIllegalJcrChars((String)username));
            } else {
                node = sub.getNode();
            }
            ((JCRSubscription)subscription).merge(node);
        }
        catch (RepositoryException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }
}

