/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jcr.JCRImapConstants;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.store.transaction.TransactionalMapper;

public abstract class AbstractJCRScalingMapper
extends TransactionalMapper
implements JCRImapConstants {
    public static final String MAILBOXES_PATH = "mailboxes";
    private final MailboxSessionJCRRepository repository;
    private final int scaling;
    private final MailboxSession mSession;
    private static final char PAD = '_';

    public AbstractJCRScalingMapper(MailboxSessionJCRRepository repository, MailboxSession mSession, int scaling) {
        this.scaling = scaling;
        this.mSession = mSession;
        this.repository = repository;
    }

    protected Session getSession() throws RepositoryException {
        return this.repository.login(this.mSession);
    }

    protected void begin() throws MailboxException {
        try {
            this.getSession().refresh(true);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    protected void commit() throws MailboxException {
        try {
            if (this.getSession().hasPendingChanges()) {
                this.getSession().save();
            }
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to commit", (Throwable)e);
        }
    }

    protected void rollback() throws MailboxException {
        try {
            this.getSession().refresh(false);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void endRequest() {
        this.repository.logout(this.mSession);
    }

    protected String constructUserPathPart(String username) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.scaling; ++i) {
            if (username.length() > i) {
                sb.append(username.substring(0, i + 1));
            } else {
                sb.append(username);
                int a = i - username.length();
                for (int b = 0; b < a; ++b) {
                    sb.append('_');
                }
            }
            sb.append("/");
        }
        sb.append(username);
        return sb.toString();
    }

    protected Node createUserPathStructure(Node parent, String username) throws RepositoryException {
        String userpath = this.constructUserPathPart(username);
        String[] userPathParts = userpath.split("/");
        for (int a = 0; a < userPathParts.length; ++a) {
            parent = JcrUtils.getOrAddNode((Node)parent, (String)userPathParts[a], (String)"nt:unstructured");
            if (a + 1 != userPathParts.length) continue;
            parent.addMixin("jamesMailbox:user");
        }
        return parent;
    }
}

