/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import org.apache.james.transport.matchers.GenericRegexMatcher;
import org.apache.mailet.Experimental;

@Experimental
public class FileRegexMatcher
extends GenericRegexMatcher {
    @Override
    public void init() throws MessagingException {
        RandomAccessFile patternSource = null;
        try {
            patternSource = new RandomAccessFile(this.getCondition(), "r");
            int lines = 0;
            while (patternSource.readLine() != null) {
                ++lines;
            }
            this.patterns = new Object[lines][2];
            patternSource.seek(0L);
            for (int i = 0; i < lines; ++i) {
                String line = patternSource.readLine();
                this.patterns[i][0] = line.substring(0, line.indexOf(58));
                this.patterns[i][1] = line.substring(line.indexOf(58) + 1);
            }
            this.compile(this.patterns);
        }
        catch (FileNotFoundException fnfe) {
            throw new MessagingException("Could not locate patterns.", (Exception)fnfe);
        }
        catch (IOException ioe) {
            throw new MessagingException("Could not read patterns.", (Exception)ioe);
        }
        catch (PatternSyntaxException mp) {
            throw new MessagingException("Could not initialize regex patterns", (Exception)mp);
        }
        finally {
            if (patternSource != null) {
                try {
                    patternSource.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

