/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.javax.MultipartUtil;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.transport.mailets.ContentReplacer;
import org.apache.james.transport.mailets.PatternExtractor;
import org.apache.james.transport.mailets.ReplacingPattern;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StripAttachment
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(StripAttachment.class);
    private static final String MULTIPART_MIME_TYPE = "multipart/*";
    public static final String PATTERN_PARAMETER_NAME = "pattern";
    public static final String NOTPATTERN_PARAMETER_NAME = "notpattern";
    public static final String MIMETYPE_PARAMETER_NAME = "mimeType";
    public static final String ATTRIBUTE_PARAMETER_NAME = "attribute";
    public static final String DIRECTORY_PARAMETER_NAME = "directory";
    public static final String REMOVE_ATTACHMENT_PARAMETER_NAME = "remove";
    public static final String DECODE_FILENAME_PARAMETER_NAME = "decodeFilename";
    public static final String REPLACE_FILENAME_PATTERN_PARAMETER_NAME = "replaceFilenamePattern";
    public static final String REMOVE_NONE = "no";
    public static final String REMOVE_ALL = "all";
    public static final String REMOVE_MATCHED = "matched";
    public static final String REMOVED_ATTACHMENTS_ATTRIBUTE_KEY = "org.apache.james.mailet.standard.mailets.StripAttachment.removed";
    public static final String SAVED_ATTACHMENTS_ATTRIBUTE_KEY = "org.apache.james.mailet.standard.mailets.StripAttachment.saved";
    public static final boolean DECODE_FILENAME_DEFAULT_VALUE = false;
    @VisibleForTesting
    String removeAttachments;
    private String directoryName;
    private String attributeName;
    private Pattern regExPattern;
    private Pattern notRegExPattern;
    private String mimeType;
    private boolean decodeFilename;
    private List<ReplacingPattern> filenameReplacingPatterns;

    public void init() throws MailetException {
        this.regExPattern = this.regExFromParameter(PATTERN_PARAMETER_NAME);
        this.notRegExPattern = this.regExFromParameter(NOTPATTERN_PARAMETER_NAME);
        this.mimeType = this.getInitParameter(MIMETYPE_PARAMETER_NAME);
        if (this.regExPattern == null && this.notRegExPattern == null && Strings.isNullOrEmpty((String)this.mimeType)) {
            throw new MailetException("At least one of 'pattern', 'notpattern' or 'mimeType' parameter should be provided.");
        }
        this.directoryName = this.getInitParameter(DIRECTORY_PARAMETER_NAME);
        this.attributeName = this.getInitParameter(ATTRIBUTE_PARAMETER_NAME);
        this.removeAttachments = this.getInitParameter(REMOVE_ATTACHMENT_PARAMETER_NAME, REMOVE_NONE).toLowerCase(Locale.US);
        if (!(this.removeAttachments.equals(REMOVE_MATCHED) || this.removeAttachments.equals(REMOVE_ALL) || this.removeAttachments.equals(REMOVE_NONE))) {
            throw new MailetException(String.format("Unknown remove parameter value '%s' waiting for '%s', '%s' or '%s'.", this.removeAttachments, REMOVE_MATCHED, REMOVE_ALL, REMOVE_NONE));
        }
        if (this.directoryName != null) {
            this.createDirectory();
        }
        this.decodeFilename = this.getBooleanParameter(this.getInitParameter(DECODE_FILENAME_PARAMETER_NAME), false);
        String replaceFilenamePattern = this.getInitParameter(REPLACE_FILENAME_PATTERN_PARAMETER_NAME);
        this.filenameReplacingPatterns = replaceFilenamePattern != null ? new PatternExtractor().getPatternsFromString(replaceFilenamePattern) : ImmutableList.of();
        this.logConfiguration();
    }

    private Pattern regExFromParameter(String patternParameterName) throws MailetException {
        String patternString = this.getInitParameter(patternParameterName);
        try {
            if (patternString != null) {
                return Pattern.compile(patternString);
            }
            return null;
        }
        catch (Exception e) {
            throw new MailetException("Could not compile regex [" + patternString + "].");
        }
    }

    private void createDirectory() throws MailetException {
        try {
            FileUtils.forceMkdir((File)new File(this.directoryName));
        }
        catch (Exception e) {
            throw new MailetException("Could not create directory [" + this.directoryName + "].", e);
        }
    }

    private void logConfiguration() {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder logMessage = new StringBuilder();
            logMessage.append("StripAttachment is initialised with regex pattern [");
            if (this.regExPattern != null) {
                logMessage.append(this.regExPattern.pattern());
            }
            logMessage.append(" / ");
            if (this.notRegExPattern != null) {
                logMessage.append(this.notRegExPattern.pattern());
            }
            logMessage.append(']');
            if (this.directoryName != null) {
                logMessage.append(" and will save to directory [");
                logMessage.append(this.directoryName);
                logMessage.append(']');
            }
            if (this.attributeName != null) {
                logMessage.append(" and will store attachments to attribute [");
                logMessage.append(this.attributeName);
                logMessage.append(']');
            }
            LOGGER.debug(logMessage.toString());
        }
    }

    public void service(Mail mail) throws MailetException {
        MimeMessage message = this.getMessageFromMail(mail);
        if (this.isMultipart((Part)message)) {
            this.processMultipartPartMessage((Part)message, mail);
        }
    }

    private boolean isMultipart(Part part) throws MailetException {
        try {
            return part.isMimeType(MULTIPART_MIME_TYPE);
        }
        catch (MessagingException e) {
            throw new MailetException("Could not retrieve contenttype of MimePart.", (Exception)((Object)e));
        }
    }

    private MimeMessage getMessageFromMail(Mail mail) throws MailetException {
        try {
            return mail.getMessage();
        }
        catch (MessagingException e) {
            throw new MailetException("Could not retrieve message from Mail object", (Exception)((Object)e));
        }
    }

    public String getMailetInfo() {
        return "StripAttachment";
    }

    @VisibleForTesting
    boolean processMultipartPartMessage(Part part, Mail mail) throws MailetException {
        if (!this.isMultipart(part)) {
            return false;
        }
        try {
            Multipart multipart = (Multipart)part.getContent();
            boolean atLeastOneRemoved = false;
            boolean subpartHasBeenChanged = false;
            List bodyParts = MultipartUtil.retrieveBodyParts((Multipart)multipart);
            for (BodyPart bodyPart : bodyParts) {
                if (this.isMultipart((Part)bodyPart)) {
                    if (!this.processMultipartPartMessage((Part)bodyPart, mail)) continue;
                    subpartHasBeenChanged = true;
                    continue;
                }
                if (!this.shouldBeRemoved(bodyPart, mail)) continue;
                multipart.removeBodyPart(bodyPart);
                atLeastOneRemoved = true;
            }
            if (atLeastOneRemoved || subpartHasBeenChanged) {
                this.updateBodyPart(part, multipart);
            }
            return atLeastOneRemoved || subpartHasBeenChanged;
        }
        catch (Exception e) {
            LOGGER.error("Failing while analysing part for attachments (StripAttachment mailet).", (Throwable)e);
            return false;
        }
    }

    private void updateBodyPart(Part part, Multipart newPartContent) throws MessagingException {
        part.setContent(newPartContent);
        if (part instanceof Message) {
            ((Message)part).saveChanges();
        }
    }

    private boolean shouldBeRemoved(BodyPart bodyPart, Mail mail) throws MessagingException, Exception {
        String fileName = this.getFilename(bodyPart);
        boolean shouldRemove = this.removeAttachments.equals(REMOVE_ALL);
        String decodedName = DecoderUtil.decodeEncodedWords((String)fileName, (DecodeMonitor)DecodeMonitor.SILENT);
        if (this.isMatching(bodyPart, decodedName)) {
            this.storeBodyPartAsFile(bodyPart, mail, decodedName);
            this.storeBodyPartAsMailAttribute(bodyPart, mail, decodedName);
            if (this.removeAttachments.equals(REMOVE_MATCHED)) {
                shouldRemove = true;
            }
        }
        this.storeFileNameAsAttribute(mail, fileName, shouldRemove);
        return shouldRemove;
    }

    private boolean isMatching(BodyPart bodyPart, String fileName) throws MessagingException {
        return this.fileNameMatches(fileName) || bodyPart.isMimeType(this.mimeType);
    }

    private void storeBodyPartAsFile(BodyPart bodyPart, Mail mail, String fileName) throws Exception {
        Optional<String> filename;
        if (this.directoryName != null && (filename = this.saveAttachmentToFile((Part)bodyPart, Optional.of(fileName))).isPresent()) {
            this.addFilenameToAttribute(mail, filename.get(), SAVED_ATTACHMENTS_ATTRIBUTE_KEY);
        }
    }

    private void addFilenameToAttribute(Mail mail, String filename, String attributeName) {
        ArrayList<String> attributeValues = (ArrayList<String>)mail.getAttribute(attributeName);
        if (attributeValues == null) {
            attributeValues = new ArrayList<String>();
            mail.setAttribute(attributeName, (Serializable)attributeValues);
        }
        attributeValues.add(filename);
    }

    private void storeBodyPartAsMailAttribute(BodyPart bodyPart, Mail mail, String fileName) throws IOException, MessagingException {
        if (this.attributeName != null) {
            this.addPartContent(bodyPart, mail, fileName);
        }
    }

    private void addPartContent(BodyPart bodyPart, Mail mail, String fileName) throws IOException, MessagingException {
        LinkedHashMap<String, byte[]> fileNamesToPartContent = (LinkedHashMap<String, byte[]>)mail.getAttribute(this.attributeName);
        if (fileNamesToPartContent == null) {
            fileNamesToPartContent = new LinkedHashMap<String, byte[]>();
            mail.setAttribute(this.attributeName, (Serializable)fileNamesToPartContent);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bodyPart.writeTo((OutputStream)new BufferedOutputStream(byteArrayOutputStream));
        fileNamesToPartContent.put(fileName, byteArrayOutputStream.toByteArray());
    }

    private void storeFileNameAsAttribute(Mail mail, String fileName, boolean hasToBeStored) {
        if (hasToBeStored) {
            this.addFilenameToAttribute(mail, fileName, REMOVED_ATTACHMENTS_ATTRIBUTE_KEY);
        }
    }

    @VisibleForTesting
    String getFilename(BodyPart bodyPart) {
        try {
            String fileName = bodyPart.getFileName();
            if (fileName != null) {
                return this.renameWithConfigurationPattern(this.decodeFilename(fileName));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unparsable filename, using a random filename instead.", (Throwable)e);
        }
        return this.randomFilename();
    }

    private String randomFilename() {
        return UUID.randomUUID().toString();
    }

    private String renameWithConfigurationPattern(String fileName) {
        if (this.filenameReplacingPatterns != null) {
            boolean debug = false;
            return new ContentReplacer(debug).applyPatterns(this.filenameReplacingPatterns, fileName);
        }
        return fileName;
    }

    private String decodeFilename(String fileName) throws UnsupportedEncodingException {
        if (this.decodeFilename) {
            return MimeUtility.decodeText((String)fileName);
        }
        return fileName;
    }

    @VisibleForTesting
    boolean fileNameMatches(String name) {
        if (this.patternsAreEquals()) {
            return false;
        }
        boolean result = this.isMatchingPattern(name, this.regExPattern).orElse(false) != false || this.isMatchingPattern(name, this.notRegExPattern).orElse(true) == false;
        LOGGER.debug("attachment {} {}", (Object)name, (Object)(result ? "matches" : "does not match"));
        return result;
    }

    private boolean patternsAreEquals() {
        return this.regExPattern != null && this.notRegExPattern != null && this.regExPattern.pattern().equals(this.notRegExPattern.pattern());
    }

    private Optional<Boolean> isMatchingPattern(String name, Pattern pattern) {
        if (pattern != null) {
            return Optional.of(pattern.matcher(name).matches());
        }
        return Optional.empty();
    }

    @VisibleForTesting
    Optional<String> saveAttachmentToFile(Part part, Optional<String> fileName) throws Exception {
        try {
            File outputFile = this.outputFile(part, fileName);
            LOGGER.debug("saving content of {}...", (Object)outputFile.getName());
            IOUtils.copy((InputStream)part.getInputStream(), (OutputStream)new FileOutputStream(outputFile));
            return Optional.of(outputFile.getName());
        }
        catch (Exception e) {
            LOGGER.error("Error while saving contents of", (Throwable)e);
            return Optional.empty();
        }
    }

    private File outputFile(Part part, Optional<String> fileName) throws MessagingException, IOException {
        Optional<String> maybePartFileName = Optional.ofNullable(part.getFileName());
        return this.createTempFile(fileName.orElse(maybePartFileName.orElse(null)));
    }

    private File createTempFile(String originalFileName) throws IOException {
        OutputFileName outputFileName = OutputFileName.from(originalFileName);
        return File.createTempFile(outputFileName.getPrefix(), outputFileName.getSuffix(), new File(this.directoryName));
    }

    @VisibleForTesting
    static class OutputFileName {
        private static final char PAD_CHAR = '_';
        private static final int MIN_LENGTH = 3;
        private static final String DEFAULT_SUFFIX = ".bin";
        private final String prefix;
        private final String suffix;

        public static OutputFileName from(String originalFileName) {
            if (!originalFileName.contains(".")) {
                return new OutputFileName(OutputFileName.prependedPrefix(originalFileName), DEFAULT_SUFFIX);
            }
            int lastDotPosition = originalFileName.lastIndexOf(".");
            return new OutputFileName(OutputFileName.prependedPrefix(originalFileName.substring(0, lastDotPosition)), originalFileName.substring(lastDotPosition));
        }

        @VisibleForTesting
        static String prependedPrefix(String prefix) {
            return Strings.padStart((String)prefix, (int)3, (char)'_');
        }

        private OutputFileName(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

