/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class ClassifyBounce
extends GenericMailet {
    private String headerName;

    public void init() throws MessagingException {
        this.headerName = this.getInitParameter("headerName");
        if (this.headerName == null || this.headerName.equals("")) {
            throw new MessagingException("Please configure a header name to contain the classification (if any).");
        }
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        Classifier classifier = new Classifier((Message)message);
        String classification = classifier.getClassification();
        message.setHeader(this.headerName, classification);
        message.saveChanges();
    }

    public String getMailetInfo() {
        return "SetMimeHeader Mailet";
    }

    private static class Classifier {
        private final String subject;
        private final String text;
        public static final int TYPE_NORMAL = 1;
        public static final int TYPE_OUT_OF_OFFICE = 3;
        public static final int TYPE_DELIVERY_FAILURE = 4;
        public static final int TYPE_MAILBOX_FULL = 5;

        public Classifier(Message message) throws MessagingException {
            this.subject = message.getSubject();
            try {
                this.text = this.getRawText(message.getContent());
            }
            catch (IOException e) {
                throw new MessagingException("Unable to extract message body.", (Exception)e);
            }
        }

        public String getClassification() throws MessagingException {
            String classification = "Normal";
            switch (this.assess()) {
                case 4: {
                    classification = "Delivery failure";
                    break;
                }
                case 5: {
                    classification = "Mailbox full";
                    break;
                }
                case 3: {
                    classification = "Out of the office";
                }
            }
            return classification;
        }

        private int assess() throws MessagingException {
            int messageNature = 1;
            boolean mailBoxFull = false;
            boolean failure = false;
            boolean outOfOffice = this.assessMessageSubjectOutOfOffice();
            if (!outOfOffice) {
                mailBoxFull = this.assessMessageSubjectMailboxFull();
            }
            if (!outOfOffice && !mailBoxFull) {
                failure = this.assessMessageSubjectFailure();
            }
            if (!(outOfOffice || mailBoxFull || failure)) {
                if (this.assessMessageUnreadable()) {
                    failure = true;
                } else {
                    outOfOffice = this.assessMessageOutOfOffice();
                    mailBoxFull = this.assessMessageMailboxFull();
                    if (!outOfOffice && !mailBoxFull) {
                        failure = this.assessMessageFailure();
                    }
                }
            }
            if (failure) {
                messageNature = 4;
            }
            if (mailBoxFull) {
                messageNature = 5;
            }
            if (outOfOffice) {
                messageNature = 3;
            }
            return messageNature;
        }

        private String getRawText(Object o) throws MessagingException, IOException {
            String s = null;
            if (o instanceof Multipart) {
                Multipart multi = (Multipart)o;
                for (int i = 0; i < multi.getCount() && ((s = this.getRawText(multi.getBodyPart(i))) == null || s.length() <= 0); ++i) {
                }
            } else if (o instanceof BodyPart) {
                BodyPart aBodyContent = (BodyPart)o;
                StringTokenizer aTypeTokenizer = new StringTokenizer(aBodyContent.getContentType(), "/");
                String abstractType = aTypeTokenizer.nextToken();
                if (abstractType.compareToIgnoreCase("MESSAGE") == 0) {
                    Message inlineMessage = (Message)aBodyContent.getContent();
                    s = this.getRawText(inlineMessage.getContent());
                }
                if (abstractType.compareToIgnoreCase("APPLICATION") == 0) {
                    s = "Attached File: " + aBodyContent.getFileName();
                }
                if (abstractType.compareToIgnoreCase("TEXT") == 0) {
                    try {
                        Object oS = aBodyContent.getContent();
                        if (!(oS instanceof String)) {
                            throw new MessagingException("Unkown MIME Type (?): " + oS.getClass());
                        }
                        s = (String)oS;
                    }
                    catch (Exception e) {
                        throw new MessagingException("Unable to read message contents (" + e.getMessage() + ")");
                    }
                }
                if (abstractType.compareToIgnoreCase("MULTIPART") == 0) {
                    s = this.getRawText(aBodyContent.getContent());
                }
            }
            if (o instanceof String) {
                s = (String)o;
            }
            return s;
        }

        private boolean assessMessageUnreadable() throws MessagingException {
            boolean evil = false;
            if (this.subject.compareToIgnoreCase("Delivery Status Notification (Failure)") == 0) {
                evil = this.findInBody("Unable to read message contents");
            }
            return evil;
        }

        private boolean assessMessageFailure() {
            boolean failed = this.findInBody("User[\\s]+unknown");
            if (!failed) {
                failed = this.findInBody("No[\\s]+such[\\s]+user");
            }
            if (!failed) {
                failed = this.findInBody("550[\\s]+Invalid[\\s]+recipient");
            }
            if (!failed) {
                failed = this.findInBody("550[\\s]+Bogus[\\s]+Address");
            }
            if (!failed) {
                failed = this.findInBody("addresses[\\s]+were[\\s]+unknown");
            }
            if (!failed) {
                failed = this.findInBody("user[\\s]+is[\\s]+no[\\s]+longer[\\s]+associated[\\s]+with[\\s]+this[\\s]+company");
            }
            if (!failed) {
                failed = this.findInBody("Unknown[\\s]+Recipient");
            }
            if (!failed) {
                failed = this.findInBody("destination[\\s]+addresses[\\s]+were[\\s]+unknown");
            }
            if (!failed) {
                failed = this.findInBody("unknown[\\s]+user");
            }
            if (!failed) {
                failed = this.findInBody("recipient[\\s]+name[\\s]+is[\\s]+not[\\s]+recognized");
            }
            if (!failed) {
                failed = this.findInBody("not[\\s]+listed[\\s]+in[\\s]+Domino[\\s]+Directory");
            }
            if (!failed) {
                failed = this.findInBody("Delivery[\\s]+Status[\\s]+Notification[\\s]+\\Q(\\EFailure\\Q)\\E");
            }
            if (!failed) {
                failed = this.findInBody("This[\\s]+is[\\s]+a[\\s]+permanent[\\s]+error");
            }
            if (!failed) {
                failed = this.findInBody("This[\\s]+account[\\s]+has[\\s]+been[\\s]+closed");
            }
            if (!failed) {
                failed = this.findInBody("addresses[\\s]+had[\\s]+permanent[\\s]+fatal[\\s]+errors");
            }
            return failed;
        }

        private boolean assessMessageMailboxFull() {
            boolean full = this.findInBody("Connection[\\s]+timed[\\s]+out");
            if (!full) {
                full = this.findInBody("Over[\\s]+quota");
            }
            if (!full) {
                full = this.findInBody("size[\\s]+limit");
            }
            if (!full) {
                full = this.findInBody("account[\\s]+is[\\s]+full");
            }
            if (!full) {
                full = this.findInBody("diskspace[\\s]+quota");
            }
            if (!full) {
                full = this.findInBody("rejected[\\s]+for[\\s]+policy[\\s]+reasons");
            }
            if (!full) {
                full = this.findInBody("mailbox[\\s]+size[\\s]+limit");
            }
            return full;
        }

        private boolean assessMessageOutOfOffice() {
            boolean out = this.findInBody("out[\\s]+of[\\s]+the[\\s]+office");
            if (!out) {
                out = this.findInBody("out[\\s]+of[\\s]+my[\\s]+office");
            }
            if (!out) {
                out = this.findInBody("back[\\s]+in[\\s]+the[\\s]+office");
            }
            if (!out) {
                out = this.findInBody("I[\\s]+am[\\s]+overseas");
            }
            if (!out) {
                out = this.findInBody("I[\\s]+am[\\s]+away");
            }
            if (!out) {
                out = this.findInBody("I[\\s]+am[\\s]+on[\\s]+leave");
            }
            if (!out) {
                out = this.findInBody("Auto[\\s]*generated") && this.findInBody("on[\\s]+leave");
            }
            return out;
        }

        private boolean assessMessageSubjectOutOfOffice() {
            boolean out = this.findInSubject("Out[\\s]+of[\\s]+office");
            if (!out) {
                out = this.findInSubject("Out[\\s]+of[\\s]+my[\\s]+office");
            }
            if (!out) {
                out = this.findInSubject("out[\\s]+of[\\s]+the[\\s]+office");
            }
            if (!out) {
                out = this.findInSubject("away[\\s]+from[\\s]+my[\\s]+mail");
            }
            if (!out) {
                out = this.findInSubject("on[\\s]+leave");
            }
            return out;
        }

        private boolean assessMessageSubjectMailboxFull() {
            return this.findInSubject("Email[\\s]+message[\\s]+blocked") && this.findInSubject("Image[\\s]+File[\\s]+Type");
        }

        private boolean assessMessageSubjectFailure() {
            boolean failed;
            boolean bl = failed = this.findInSubject("DELIVERY[\\s]+FAILURE") && this.findInSubject("does[\\s]+not[\\s]+exist");
            if (!failed) {
                boolean bl2 = failed = this.findInSubject("DELIVERY[\\s]+FAILURE") && this.findInSubject("not[\\s]+listed");
            }
            if (!failed) {
                failed = this.findInSubject("Permanent[\\s]+Delivery[\\s]+Failure");
            }
            if (!failed) {
                failed = this.findInSubject("User[\\s]+unknown");
            }
            if (!failed) {
                String s = this.subject.toLowerCase(Locale.US);
                failed = s.indexOf("user") > 0 && s.indexOf("unknown") > s.indexOf("user");
            }
            return failed;
        }

        private boolean findInBody(String regExp) {
            boolean retval = false;
            if (this.text != null) {
                Pattern pat = Pattern.compile(regExp, 2);
                Matcher m = pat.matcher(this.text);
                retval = m.find();
            }
            return retval;
        }

        private boolean findInSubject(String regExp) {
            Pattern pat = Pattern.compile(regExp, 2);
            Matcher m = pat.matcher(this.subject);
            return m.find();
        }
    }
}

