/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import java.io.Closeable;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.adapter.mailbox.ReIndexerManagementMBean;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.util.MDCBuilder;

public class ReIndexerManagement
implements ReIndexerManagementMBean {
    private ReIndexer reIndexer;

    @Inject
    public void setReIndexer(@Named(value="reindexer") ReIndexer reIndexer) {
        this.reIndexer = reIndexer;
    }

    @Override
    public void reIndex(String namespace, String user, String name) throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"reIndex").build();){
            this.reIndexer.reIndex(new MailboxPath(namespace, user, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reIndex() throws MailboxException {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"reIndex").build();){
            this.reIndexer.reIndex();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

