/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.IdleRequest;
import org.apache.james.imap.message.response.ContinuationResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleProcessor
extends AbstractMailboxProcessor<IdleRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleProcessor.class);
    private static final List<String> CAPS = ImmutableList.of((Object)"IDLE");
    public static final int DEFAULT_SCHEDULED_POOL_CORE_SIZE = 5;
    private static final String DONE = "DONE";
    private TimeUnit heartbeatIntervalUnit;
    private long heartbeatInterval;
    private boolean enableIdle;
    private ScheduledExecutorService heartbeatExecutor;

    public IdleProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(IdleRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.heartbeatInterval = imapConfiguration.getIdleTimeInterval();
        this.heartbeatIntervalUnit = imapConfiguration.getIdleTimeIntervalUnit();
        this.enableIdle = imapConfiguration.isEnableIdle();
        if (this.enableIdle) {
            this.heartbeatExecutor = Executors.newScheduledThreadPool(5);
        }
    }

    @Override
    protected void doProcess(IdleRequest message, final ImapSession session, final String tag, final ImapCommand command, final ImapProcessor.Responder responder) {
        try {
            IdleMailboxListener idleListener;
            final MailboxManager mailboxManager = this.getMailboxManager();
            final MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            final SelectedMailbox sm = session.getSelected();
            if (sm != null) {
                idleListener = new IdleMailboxListener(session, responder);
                mailboxManager.addListener(sm.getPath(), (MailboxListener)idleListener, mailboxSession);
            } else {
                idleListener = null;
            }
            final AtomicBoolean idleActive = new AtomicBoolean(true);
            session.pushLineHandler(new ImapLineHandler(){

                @Override
                public void onLine(ImapSession session, byte[] data) {
                    String line = data.length > 2 ? new String(data, 0, data.length - 2) : "";
                    if (idleListener != null) {
                        try {
                            mailboxManager.removeListener(sm.getPath(), (MailboxListener)idleListener, mailboxSession);
                        }
                        catch (MailboxException e) {
                            LOGGER.error("Unable to remove idle listener for mailbox {}", (Object)sm.getPath(), (Object)e);
                        }
                    }
                    session.popLineHandler();
                    if (!IdleProcessor.DONE.equals(line.toUpperCase(Locale.US))) {
                        StatusResponse response = IdleProcessor.this.getStatusResponseFactory().taggedBad(tag, command, HumanReadableText.INVALID_COMMAND);
                        responder.respond(response);
                    } else {
                        IdleProcessor.this.okComplete(command, tag, responder);
                    }
                    idleActive.set(false);
                }
            });
            if (this.enableIdle) {
                this.heartbeatExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (session.getState() != ImapSessionState.LOGOUT && idleActive.get()) {
                            StatusResponse response = IdleProcessor.this.getStatusResponseFactory().untaggedOk(HumanReadableText.HEARTBEAT);
                            responder.respond(response);
                            IdleProcessor.this.heartbeatExecutor.schedule(this, IdleProcessor.this.heartbeatInterval, IdleProcessor.this.heartbeatIntervalUnit);
                        }
                    }
                }, this.heartbeatInterval, this.heartbeatIntervalUnit);
            }
            responder.respond(new ContinuationResponse(HumanReadableText.IDLING));
            this.unsolicitedResponses(session, responder, false);
        }
        catch (MailboxException e) {
            LOGGER.error("Enable idle for {} failed", (Object)session.getSelected().getPath(), (Object)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected Closeable addContextToMDC(IdleRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"IDLE").build();
    }

    private class IdleMailboxListener
    implements MailboxListener {
        private final ImapProcessor.Responder responder;
        private final ImapSession session;

        public IdleMailboxListener(ImapSession session, ImapProcessor.Responder responder) {
            this.session = session;
            this.responder = responder;
        }

        public void event(Event event) {
            if (event instanceof MailboxListener.Added || event instanceof MailboxListener.Expunged || event instanceof MailboxListener.FlagsUpdated) {
                IdleProcessor.this.unsolicitedResponses(this.session, this.responder, false);
            }
        }

        public MailboxListener.ListenerType getType() {
            return MailboxListener.ListenerType.MAILBOX;
        }
    }
}

