/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.AnnotationResponse;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationResponseEncoder
extends AbstractChainedImapEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationResponseEncoder.class);

    public AnnotationResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        AnnotationResponse response = (AnnotationResponse)acceptableMessage;
        composer.untagged();
        composer.commandName("METADATA");
        composer.quote(Optional.ofNullable(response.getMailboxName()).orElse(""));
        this.composeAnnotations(composer, session, response.getMailboxAnnotations());
        composer.end();
    }

    private void composeAnnotations(ImapResponseComposer composer, ImapSession session, List<MailboxAnnotation> annotations) throws IOException {
        if (!annotations.isEmpty()) {
            composer.openParen();
            for (MailboxAnnotation annotation : annotations) {
                this.composeAnnotation(composer, session, annotation);
            }
            composer.closeParen();
        }
    }

    private void composeAnnotation(ImapResponseComposer composer, ImapSession session, MailboxAnnotation annotation) throws IOException {
        if (annotation.isNil()) {
            LOGGER.warn("There is nil data of key {} on store: ", (Object)annotation.getKey().asString());
        } else {
            composer.message(annotation.getKey().asString());
            composer.quote(annotation.getValue().orElse(""));
        }
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof AnnotationResponse;
    }
}

