/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.openjpa;

import javax.inject.Inject;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.jpa.JPAMailboxManager;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMessageManager;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;

public class OpenJPAMailboxManager
extends JPAMailboxManager {
    @Inject
    public OpenJPAMailboxManager(JPAMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, Authorizator authorizator, MessageParser messageParser, MessageId.Factory messageIdFactory, DelegatingMailboxListener delegatingMailboxListener, MailboxEventDispatcher mailboxEventDispatcher, StoreMailboxAnnotationManager annotationManager, StoreRightManager storeRightManager) {
        super(mapperFactory, authenticator, authorizator, (MailboxPathLocker)new JVMMailboxPathLocker(), messageParser, messageIdFactory, delegatingMailboxListener, mailboxEventDispatcher, annotationManager, storeRightManager);
    }

    protected OpenJPAMessageManager.AdvancedFeature getAdvancedFeature() {
        return OpenJPAMessageManager.AdvancedFeature.None;
    }

    protected StoreMessageManager createMessageManager(Mailbox mailboxRow, MailboxSession session) {
        return new OpenJPAMessageManager(this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventDispatcher(), this.getLocker(), mailboxRow, this.getAdvancedFeature(), this.getQuotaManager(), this.getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.getBatchSizes(), this.getImmutableMailboxMessageFactory(), this.getStoreRightManager());
    }
}

