/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.StringTokenizer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.AuthHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.james.protocols.smtp.util.Base64;
import org.apache.james.util.OptionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthCmdHandler
implements CommandHandler<SMTPSession>,
EhloExtension,
ExtensibleHandler,
MailParametersHook {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"AUTH");
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandHandler.class);
    private static final String[] MAIL_PARAMS = new String[]{"AUTH"};
    private static final List<String> ESMTP_FEATURES = ImmutableList.of((Object)"AUTH LOGIN PLAIN", (Object)"AUTH=LOGIN PLAIN");
    private static final Response AUTH_ABORTED = new SMTPResponse("501", DSNStatus.getStatus(5, "7.1") + " Authentication aborted").immutable();
    private static final Response ALREADY_AUTH = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " User has previously authenticated.  Further authentication is not required!").immutable();
    private static final Response SYNTAX_ERROR = new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Usage: AUTH (authentication type) <challenge>").immutable();
    private static final Response AUTH_READY_PLAIN = new SMTPResponse("334", "OK. Continue authentication").immutable();
    private static final Response AUTH_READY_USERNAME_LOGIN = new SMTPResponse("334", "VXNlcm5hbWU6").immutable();
    private static final Response AUTH_READY_PASSWORD_LOGIN = new SMTPResponse("334", "UGFzc3dvcmQ6").immutable();
    private static final Response AUTH_FAILED = new SMTPResponse("535", "Authentication Failed").immutable();
    private static final Response UNKNOWN_AUTH_TYPE = new SMTPResponse("504", "Unrecognized Authentication Type").immutable();
    protected static final String AUTH_TYPE_PLAIN = "PLAIN";
    protected static final String AUTH_TYPE_LOGIN = "LOGIN";
    private List<AuthHook> hooks;
    private List<HookResultHook> rHooks;

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Response onCommand(SMTPSession session, Request request) {
        return this.doAUTH(session, request.getArgument());
    }

    private Response doAUTH(SMTPSession session, String argument) {
        String authType;
        if (session.getUser() != null) {
            return ALREADY_AUTH;
        }
        if (argument == null) {
            return SYNTAX_ERROR;
        }
        String initialResponse = null;
        if (argument != null && argument.indexOf(" ") > 0) {
            initialResponse = argument.substring(argument.indexOf(" ") + 1);
            argument = argument.substring(0, argument.indexOf(" "));
        }
        if ((authType = argument.toUpperCase(Locale.US)).equals(AUTH_TYPE_PLAIN)) {
            if (initialResponse == null) {
                session.pushLineHandler(new AbstractSMTPLineHandler(){

                    @Override
                    protected Response onCommand(SMTPSession session, String l) {
                        return AuthCmdHandler.this.doPlainAuthPass(session, l);
                    }

                    public void init(Configuration config) throws ConfigurationException {
                    }

                    public void destroy() {
                    }
                });
                return AUTH_READY_PLAIN;
            }
            String userpass = initialResponse.trim();
            return this.doPlainAuthPass(session, userpass);
        }
        if (authType.equals(AUTH_TYPE_LOGIN)) {
            if (initialResponse == null) {
                session.pushLineHandler(new AbstractSMTPLineHandler(){

                    @Override
                    protected Response onCommand(SMTPSession session, String l) {
                        return AuthCmdHandler.this.doLoginAuthPass(session, l);
                    }

                    public void init(Configuration config) throws ConfigurationException {
                    }

                    public void destroy() {
                    }
                });
                return AUTH_READY_USERNAME_LOGIN;
            }
            String user = initialResponse.trim();
            return this.doLoginAuthPass(session, user);
        }
        return this.doUnknownAuth(session, authType, initialResponse);
    }

    private Response doPlainAuthPass(SMTPSession session, String userpass) {
        String pass;
        String user;
        block5: {
            user = null;
            pass = null;
            try {
                if (userpass != null) {
                    userpass = new String(Base64.decodeBase64(userpass));
                }
                if (userpass == null) break block5;
                StringTokenizer authTokenizer = new StringTokenizer(userpass, "\u0000");
                String authorizeId = authTokenizer.nextToken();
                user = authTokenizer.nextToken();
                try {
                    pass = authTokenizer.nextToken();
                }
                catch (NoSuchElementException ignored) {
                    pass = user;
                    user = authorizeId;
                }
                authTokenizer = null;
            }
            catch (Exception authTokenizer) {
                // empty catch block
            }
        }
        Response response = this.doAuthTest(session, user, pass, AUTH_TYPE_PLAIN);
        session.popLineHandler();
        return response;
    }

    private Response doLoginAuthPass(SMTPSession session, String user) {
        if (user != null) {
            try {
                user = new String(Base64.decodeBase64(user));
            }
            catch (Exception e) {
                user = null;
            }
        }
        session.popLineHandler();
        session.pushLineHandler(new AbstractSMTPLineHandler(){
            private String user;

            public LineHandler<SMTPSession> setUser(String user) {
                this.user = user;
                return this;
            }

            @Override
            protected Response onCommand(SMTPSession session, String l) {
                return AuthCmdHandler.this.doLoginAuthPassCheck(session, this.user, l);
            }

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }
        }.setUser(user));
        return AUTH_READY_PASSWORD_LOGIN;
    }

    private Response doLoginAuthPassCheck(SMTPSession session, String user, String pass) {
        if (pass != null) {
            try {
                pass = new String(Base64.decodeBase64(pass));
            }
            catch (Exception e) {
                pass = null;
            }
        }
        session.popLineHandler();
        return this.doAuthTest(session, user, pass, AUTH_TYPE_LOGIN);
    }

    protected Response doAuthTest(SMTPSession session, String user, String pass, String authType) {
        if (user == null || pass == null) {
            return new SMTPResponse("501", "Could not decode parameters for AUTH " + authType);
        }
        Response res = null;
        List<AuthHook> hooks = this.getHooks();
        if (hooks != null) {
            for (AuthHook rawHook : hooks) {
                LOGGER.debug("executing  hook {}", (Object)rawHook);
                long start = System.currentTimeMillis();
                HookResult hRes = rawHook.doAuth(session, user, pass);
                long executionTime = System.currentTimeMillis() - start;
                if (this.rHooks != null) {
                    for (HookResultHook rHook : this.rHooks) {
                        LOGGER.debug("executing  hook {}", (Object)rHook);
                        hRes = rHook.onHookResult(session, hRes, executionTime, rawHook);
                    }
                }
                if ((res = this.calcDefaultSMTPResponse(hRes)) == null) continue;
                if ("535".equals(res.getRetCode())) {
                    LOGGER.info("AUTH method {} failed", (Object)authType);
                } else if ("235".equals(res.getRetCode())) {
                    LOGGER.debug("AUTH method {} succeeded", (Object)authType);
                }
                return res;
            }
        }
        res = AUTH_FAILED;
        LOGGER.error("AUTH method {} failed from {}@{}", new Object[]{authType, user, session.getRemoteAddress().getAddress().getHostAddress()});
        return res;
    }

    protected Response calcDefaultSMTPResponse(HookResult result) {
        if (result != null) {
            HookReturnCode returnCode = result.getResult();
            String smtpReturnCode = OptionalUtils.or((Optional[])new Optional[]{Optional.ofNullable(result.getSmtpRetCode()), this.retrieveDefaultSmtpReturnCode(returnCode)}).orElse(null);
            String smtpDescription = OptionalUtils.or((Optional[])new Optional[]{Optional.ofNullable(result.getSmtpDescription()), this.retrieveDefaultSmtpDescription(returnCode)}).orElse(null);
            if (HookReturnCode.Action.ACTIVE_ACTIONS.contains((Object)returnCode.getAction())) {
                SMTPResponse response = new SMTPResponse(smtpReturnCode, smtpDescription);
                if (returnCode.isDisconnected()) {
                    response.setEndSession(true);
                }
                return response;
            }
            if (returnCode.isDisconnected()) {
                SMTPResponse response = new SMTPResponse("");
                response.setEndSession(true);
                return response;
            }
        }
        return null;
    }

    private Optional<String> retrieveDefaultSmtpDescription(HookReturnCode returnCode) {
        switch (returnCode.getAction()) {
            case DENY: {
                return Optional.of("Authentication Failed");
            }
            case DENYSOFT: {
                return Optional.of("Temporary problem. Please try again later");
            }
            case OK: {
                return Optional.of("Authentication Succesfull");
            }
        }
        return Optional.empty();
    }

    private Optional<String> retrieveDefaultSmtpReturnCode(HookReturnCode returnCode) {
        switch (returnCode.getAction()) {
            case DENY: {
                return Optional.of("535");
            }
            case DENYSOFT: {
                return Optional.of("451");
            }
            case OK: {
                return Optional.of("235");
            }
        }
        return Optional.empty();
    }

    private Response doUnknownAuth(SMTPSession session, String authType, String initialResponse) {
        LOGGER.info("AUTH method {} is an unrecognized authentication type", (Object)authType);
        return UNKNOWN_AUTH_TYPE;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        if (session.isAuthSupported()) {
            return ESMTP_FEATURES;
        }
        return Collections.EMPTY_LIST;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList classes = new ArrayList(1);
        classes.add(AuthHook.class);
        return classes;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (AuthHook.class.equals(interfaceName)) {
            this.hooks = extension;
            if (this.hooks == null || this.hooks.size() == 0) {
                throw new WiringException("AuthCmdHandler used without AuthHooks");
            }
        } else if (HookResultHook.class.equals(interfaceName)) {
            this.rHooks = extension;
        }
    }

    protected List<AuthHook> getHooks() {
        return this.hooks;
    }

    @Override
    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        return HookResult.DECLINED;
    }

    @Override
    public String[] getMailParamNames() {
        return MAIL_PARAMS;
    }

    private abstract class AbstractSMTPLineHandler
    implements LineHandler<SMTPSession> {
        private AbstractSMTPLineHandler() {
        }

        public Response onLine(SMTPSession session, ByteBuffer line) {
            String charset = session.getCharset().name();
            try {
                byte[] l;
                if (line.hasArray()) {
                    l = line.array();
                } else {
                    l = new byte[line.remaining()];
                    line.get(l);
                }
                return this.handleCommand(session, new String(l, charset));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("No " + charset + " support!");
            }
        }

        private Response handleCommand(SMTPSession session, String line) {
            if (line.equals("*\r\n")) {
                session.popLineHandler();
                return AUTH_ABORTED;
            }
            return this.onCommand(session, line);
        }

        protected abstract Response onCommand(SMTPSession var1, String var2);
    }
}

