/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.UnknownHook;

public class UnknownCmdHandler
extends AbstractHookableCmdHandler<UnknownHook> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"UNKNOWN_CMD");

    @Inject
    public UnknownCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        StringBuilder result = new StringBuilder();
        result.append(DSNStatus.getStatus(5, "5.1")).append(" Command ").append(command).append(" unrecognized.");
        return new SMTPResponse("500", result);
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String parameters) {
        session.setAttachment("CURR_COMMAND", command, ProtocolSession.State.Transaction);
        return null;
    }

    @Override
    protected HookResult callHook(UnknownHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doUnknown(session, (String)session.getAttachment("CURR_COMMAND", ProtocolSession.State.Transaction));
    }

    @Override
    protected Class<UnknownHook> getHookInterface() {
        return UnknownHook.class;
    }
}

