/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RcptCmdHandler
extends AbstractHookableCmdHandler<RcptHook>
implements CommandHandler<SMTPSession> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RcptCmdHandler.class);
    public static final String CURRENT_RECIPIENT = "CURRENT_RECIPIENT";
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"RCPT");
    private static final Response MAIL_NEEDED = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " Need MAIL before RCPT").immutable();
    private static final Response SYNTAX_ERROR_ARGS = new SMTPResponse("501", DSNStatus.getStatus(5, "5.2") + " Usage: RCPT TO:<recipient>").immutable();
    private static final Response SYNTAX_ERROR_DELIVERY = new SMTPResponse("501", DSNStatus.getStatus(5, "5.2") + " Syntax error in parameters or arguments").immutable();
    private static final Response SYNTAX_ERROR_ADDRESS = new SMTPResponse("553", DSNStatus.getStatus(5, "1.3") + " Syntax error in recipient address").immutable();

    @Inject
    public RcptCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        ArrayList<MailAddress> rcptColl = (ArrayList<MailAddress>)session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction);
        if (rcptColl == null) {
            rcptColl = new ArrayList<MailAddress>();
        }
        MailAddress recipientAddress = (MailAddress)session.getAttachment(CURRENT_RECIPIENT, ProtocolSession.State.Transaction);
        rcptColl.add(recipientAddress);
        session.setAttachment("RCPT_LIST", rcptColl, ProtocolSession.State.Transaction);
        StringBuilder response = new StringBuilder();
        response.append(DSNStatus.getStatus(2, "1.5")).append(" Recipient <").append(recipientAddress).append("> OK");
        return new SMTPResponse("250", response);
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String argument) {
        String recipient = null;
        if (argument != null && argument.indexOf(":") > 0) {
            int colonIndex = argument.indexOf(":");
            recipient = argument.substring(colonIndex + 1);
            argument = argument.substring(0, colonIndex);
        }
        if (session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction) == null) {
            return MAIL_NEEDED;
        }
        if (argument == null || !argument.toUpperCase(Locale.US).equals("TO") || recipient == null) {
            return SYNTAX_ERROR_ARGS;
        }
        recipient = recipient.trim();
        int lastChar = recipient.lastIndexOf(62);
        String rcptOptionString = null;
        if (lastChar > 0 && recipient.length() > lastChar + 2 && recipient.charAt(lastChar + 1) == ' ') {
            rcptOptionString = recipient.substring(lastChar + 2);
            recipient = recipient.substring(0, lastChar + 1);
        }
        if (!(!session.getConfiguration().useAddressBracketsEnforcement() || recipient.startsWith("<") && recipient.endsWith(">"))) {
            LOGGER.info("Error parsing recipient address: Address did not start and end with < >{}", (Object)this.getContext(session, null, recipient));
            return SYNTAX_ERROR_DELIVERY;
        }
        MailAddress recipientAddress = null;
        if (session.getConfiguration().useAddressBracketsEnforcement() || recipient.startsWith("<") && recipient.endsWith(">")) {
            recipient = recipient.substring(1, recipient.length() - 1);
        }
        if (!recipient.contains("@")) {
            recipient = recipient + "@" + this.getDefaultDomain();
        }
        try {
            recipientAddress = new MailAddress(recipient);
        }
        catch (Exception pe) {
            LOGGER.info("Error parsing recipient address{}", (Object)this.getContext(session, recipientAddress, recipient), (Object)pe);
            return SYNTAX_ERROR_ADDRESS;
        }
        if (rcptOptionString != null) {
            StringTokenizer optionTokenizer = new StringTokenizer(rcptOptionString, " ");
            if (optionTokenizer.hasMoreElements()) {
                String rcptOption = optionTokenizer.nextToken();
                int equalIndex = rcptOption.indexOf(61);
                String rcptOptionName = rcptOption;
                String rcptOptionValue = "";
                if (equalIndex > 0) {
                    rcptOptionName = rcptOption.substring(0, equalIndex).toUpperCase(Locale.US);
                    rcptOptionValue = rcptOption.substring(equalIndex + 1);
                }
                LOGGER.debug("RCPT command had unrecognized/unexpected option {} with value {}{}", new Object[]{rcptOptionName, rcptOptionValue, this.getContext(session, recipientAddress, recipient)});
                return new SMTPResponse("504", "Unrecognized or unsupported option: " + rcptOptionName);
            }
            optionTokenizer = null;
        }
        session.setAttachment(CURRENT_RECIPIENT, recipientAddress, ProtocolSession.State.Transaction);
        return null;
    }

    private String getContext(SMTPSession session, MailAddress recipientAddress, String recipient) {
        StringBuilder sb = new StringBuilder(128);
        if (null != recipientAddress) {
            sb.append(" [to:").append(recipientAddress.asString()).append(']');
        } else if (null != recipient) {
            sb.append(" [to:").append(recipient).append(']');
        }
        if (null != session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction)) {
            MailAddress mailAddress = (MailAddress)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction);
            sb.append(" [from:").append(mailAddress.asString()).append(']');
        }
        return sb.toString();
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected Class<RcptHook> getHookInterface() {
        return RcptHook.class;
    }

    @Override
    protected HookResult callHook(RcptHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doRcpt(session, (MailAddress)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction), (MailAddress)session.getAttachment(CURRENT_RECIPIENT, ProtocolSession.State.Transaction));
    }

    protected String getDefaultDomain() {
        return "localhost";
    }
}

