/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.MailEnvelopeImpl;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;

public class DataCmdHandler
implements CommandHandler<SMTPSession>,
ExtensibleHandler {
    private static final Response NO_RECIPIENT = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " No recipients specified").immutable();
    private static final Response NO_SENDER = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " No sender specified").immutable();
    private static final Response UNEXPECTED_ARG = new SMTPResponse("500", DSNStatus.getStatus(5, "5.4") + " Unexpected argument provided with DATA command").immutable();
    private static final Response DATA_READY = new SMTPResponse("354", "Ok Send data ending with <CRLF>.<CRLF>").immutable();
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"DATA");
    public static final String MAILENV = "MAILENV";
    private final MetricFactory metricFactory;
    private LineHandler<SMTPSession> lineHandler;

    @Inject
    public DataCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    /*
     * Exception decompiling
     */
    public Response onCommand(SMTPSession session, Request request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Response doDATA(SMTPSession session, String argument) {
        MailEnvelope env = this.createEnvelope(session, (MailAddress)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction), new ArrayList<MailAddress>((Collection)session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction)));
        session.setAttachment(MAILENV, env, ProtocolSession.State.Transaction);
        session.pushLineHandler(this.lineHandler);
        return DATA_READY;
    }

    protected MailEnvelope createEnvelope(SMTPSession session, MailAddress sender, List<MailAddress> recipients) {
        MailEnvelopeImpl env = new MailEnvelopeImpl();
        env.setRecipients(recipients);
        env.setSender(sender);
        return env;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    public List getMarkerInterfaces() {
        LinkedList<Class<DataLineFilter>> classes = new LinkedList<Class<DataLineFilter>>();
        classes.add(DataLineFilter.class);
        return classes;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (DataLineFilter.class.equals((Object)interfaceName)) {
            Object lineHandler = new DataConsumerLineHandler();
            for (int i = extension.size() - 1; i >= 0; --i) {
                lineHandler = new DataLineFilterWrapper((DataLineFilter)extension.get(i), (LineHandler<SMTPSession>)lineHandler);
            }
            this.lineHandler = lineHandler;
        }
    }

    protected Response doDATAFilter(SMTPSession session, String argument) {
        if (argument != null && argument.length() > 0) {
            return UNEXPECTED_ARG;
        }
        if (session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction) == null) {
            return NO_SENDER;
        }
        if (session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction) == null) {
            return NO_RECIPIENT;
        }
        return null;
    }

    protected LineHandler<SMTPSession> getLineHandler() {
        return this.lineHandler;
    }

    public static final class DataLineFilterWrapper
    implements LineHandler<SMTPSession> {
        private final DataLineFilter filter;
        private final LineHandler<SMTPSession> next;

        public DataLineFilterWrapper(DataLineFilter filter, LineHandler<SMTPSession> next) {
            this.filter = filter;
            this.next = next;
        }

        public Response onLine(SMTPSession session, ByteBuffer line) {
            line.rewind();
            return this.filter.onLine(session, line, this.next);
        }

        public void init(Configuration config) throws ConfigurationException {
        }

        public void destroy() {
        }
    }

    public static final class DataConsumerLineHandler
    implements LineHandler<SMTPSession> {
        public SMTPResponse onLine(SMTPSession session, ByteBuffer line) {
            if (line.remaining() == 3 && line.get() == 46) {
                session.popLineHandler();
            }
            return null;
        }

        public void init(Configuration config) throws ConfigurationException {
        }

        public void destroy() {
        }
    }
}

