/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.user;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;

public class InMemorySubscriptionMapper
extends NonTransactionalMapper
implements SubscriptionMapper {
    private final ListMultimap<String, Subscription> subscriptionsByUser = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    public synchronized void delete(Subscription subscription) {
        this.subscriptionsByUser.remove((Object)subscription.getUser(), (Object)subscription);
    }

    public Subscription findMailboxSubscriptionForUser(String user, String mailbox) {
        ImmutableList subscriptions = ImmutableList.copyOf((Collection)this.subscriptionsByUser.get((Object)user));
        if (subscriptions != null) {
            return subscriptions.stream().filter(subscription -> subscription.getMailbox().equals(mailbox)).findFirst().orElse(null);
        }
        return null;
    }

    public List<Subscription> findSubscriptionsForUser(String user) {
        List subcriptions = this.subscriptionsByUser.get((Object)user);
        if (subcriptions == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)subcriptions);
    }

    public synchronized void save(Subscription subscription) {
        this.subscriptionsByUser.put((Object)subscription.getUser(), (Object)subscription);
    }

    public void deleteAll() {
        this.subscriptionsByUser.clear();
    }

    public void endRequest() {
    }
}

