/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.NettyImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyStreamImapRequestLineReader;
import org.apache.james.imapserver.netty.SwitchableLineBasedFrameDecoder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class ImapRequestFrameDecoder
extends FrameDecoder
implements NettyConstants {
    private final ImapDecoder decoder;
    private final int inMemorySizeLimit;
    private final int literalSizeLimit;
    private static final String NEEDED_DATA = "NEEDED_DATA";
    private static final String STORED_DATA = "STORED_DATA";
    private static final String WRITTEN_DATA = "WRITTEN_DATA";
    private static final String OUTPUT_STREAM = "OUTPUT_STREAM";

    public ImapRequestFrameDecoder(ImapDecoder decoder, int inMemorySizeLimit, int literalSizeLimit) {
        this.decoder = decoder;
        this.inMemorySizeLimit = inMemorySizeLimit;
        this.literalSizeLimit = literalSizeLimit;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.setAttachment(new HashMap());
        super.channelOpen(ctx, e);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int size;
        Map attachment;
        block14: {
            boolean retry;
            block12: {
                block13: {
                    buffer.markReaderIndex();
                    retry = false;
                    attachment = (Map)ctx.getAttachment();
                    size = -1;
                    if (!attachment.containsKey(NEEDED_DATA)) break block12;
                    retry = true;
                    size = (Integer)attachment.get(NEEDED_DATA);
                    if (size == -1 || size <= buffer.readableBytes()) break block13;
                    if (this.inMemorySizeLimit > 0 && this.inMemorySizeLimit < size) {
                        int amount;
                        OutputStream out;
                        int written;
                        File f;
                        if (attachment.containsKey(STORED_DATA)) {
                            f = (File)attachment.get(STORED_DATA);
                            written = (Integer)attachment.get(WRITTEN_DATA);
                            out = (OutputStream)attachment.get(OUTPUT_STREAM);
                        } else {
                            f = File.createTempFile("imap-literal", ".tmp");
                            attachment.put(STORED_DATA, f);
                            written = 0;
                            attachment.put(WRITTEN_DATA, written);
                            out = new FileOutputStream(f, true);
                            attachment.put(OUTPUT_STREAM, out);
                        }
                        try {
                            amount = Math.min(buffer.readableBytes(), size - written);
                            buffer.readBytes(out, amount);
                        }
                        catch (Exception e) {
                            IOUtils.closeQuietly((OutputStream)out);
                            throw e;
                        }
                        if ((written += amount) != size) {
                            attachment.put(WRITTEN_DATA, written);
                            return null;
                        }
                        IOUtils.closeQuietly((OutputStream)out);
                        NettyStreamImapRequestLineReader nettyStreamImapRequestLineReader = new NettyStreamImapRequestLineReader(channel, new FileInputStream(f){

                            @Override
                            public void close() throws IOException {
                                super.close();
                                FileUtils.forceDelete((File)f);
                            }
                        }, retry);
                        break block14;
                    } else {
                        buffer.resetReaderIndex();
                        return null;
                    }
                }
                NettyImapRequestLineReader nettyImapRequestLineReader = new NettyImapRequestLineReader(channel, buffer, retry, this.literalSizeLimit);
                break block14;
            }
            NettyImapRequestLineReader nettyImapRequestLineReader = new NettyImapRequestLineReader(channel, buffer, retry, this.literalSizeLimit);
        }
        ImapSession session = (ImapSession)attributes.get(channel);
        if (session != null && session.getState() != ImapSessionState.LOGOUT) {
            try {
                void var5_19;
                ImapMessage message = this.decoder.decode((ImapRequestLineReader)var5_19, session);
                if (size == -1) {
                    var5_19.consumeLine();
                }
                ((SwitchableLineBasedFrameDecoder)channel.getPipeline().get("framer")).enableFraming();
                attachment.clear();
                return message;
            }
            catch (NettyImapRequestLineReader.NotEnoughDataException e) {
                int neededData = e.getNeededSize();
                attachment.put(NEEDED_DATA, neededData);
                ChannelPipeline pipeline = channel.getPipeline();
                ChannelHandlerContext framerContext = pipeline.getContext("framer");
                SwitchableLineBasedFrameDecoder framer = (SwitchableLineBasedFrameDecoder)pipeline.get("framer");
                framer.disableFraming(framerContext);
                buffer.resetReaderIndex();
                return null;
            }
        }
        if (channel.isConnected()) {
            channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
        return null;
    }

    protected synchronized ChannelBuffer newCumulationBuffer(ChannelHandlerContext ctx, int minimumCapacity) {
        Map attachment = (Map)ctx.getAttachment();
        int size = (Integer)attachment.get(NEEDED_DATA);
        if (this.inMemorySizeLimit > 0) {
            return ChannelBuffers.dynamicBuffer((int)Math.min(size, this.inMemorySizeLimit), (ChannelBufferFactory)ctx.getChannel().getConfig().getBufferFactory());
        }
        if (size > 0) {
            return ChannelBuffers.dynamicBuffer((int)size, (ChannelBufferFactory)ctx.getChannel().getConfig().getBufferFactory());
        }
        return super.newCumulationBuffer(ctx, minimumCapacity);
    }
}

