/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.filter.FilterEncoder;
import org.apache.james.core.MailAddress;
import org.apache.james.core.User;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.james.user.ldap.ReadOnlyLDAPUser;
import org.apache.james.util.retry.DoublingRetrySchedule;
import org.apache.james.util.retry.api.RetrySchedule;
import org.apache.james.util.retry.naming.ldap.RetryingLdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyUsersLDAPRepository
implements UsersRepository,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadOnlyUsersLDAPRepository.class);
    private static final String INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String PROPERTY_NAME_CONNECTION_POOL = "com.sun.jndi.ldap.connect.pool";
    private static final String PROPERTY_NAME_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String PROPERTY_NAME_READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    public static final String SUPPORTS_VIRTUAL_HOSTING = "supportsVirtualHosting";
    private LdapContext ldapContext;
    private RetrySchedule schedule = null;
    private final DomainList domainList;
    private LdapRepositoryConfiguration ldapConfiguration;

    @Inject
    public ReadOnlyUsersLDAPRepository(DomainList domainList) {
        this.domainList = domainList;
    }

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.configure(LdapRepositoryConfiguration.from(configuration));
    }

    public void configure(LdapRepositoryConfiguration configuration) {
        this.ldapConfiguration = configuration;
        this.schedule = new DoublingRetrySchedule(configuration.getRetryStartInterval(), configuration.getRetryMaxInterval(), configuration.getScale());
    }

    @PostConstruct
    public void init() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getClass().getName() + ".init()" + '\n' + "LDAP host: " + this.ldapConfiguration.getLdapHost() + '\n' + "User baseDN: " + this.ldapConfiguration.getUserBase() + '\n' + "userIdAttribute: " + this.ldapConfiguration.getUserIdAttribute() + '\n' + "Group restriction: " + this.ldapConfiguration.getRestriction() + '\n' + "UseConnectionPool: " + this.ldapConfiguration.useConnectionPool() + '\n' + "connectionTimeout: " + this.ldapConfiguration.getConnectionTimeout() + '\n' + "readTimeout: " + this.ldapConfiguration.getReadTimeout() + '\n' + "retrySchedule: " + this.schedule + '\n' + "maxRetries: " + this.ldapConfiguration.getMaxRetries() + '\n');
        }
        this.updateLdapContext();
    }

    protected LdapContext getLdapContext() throws NamingException {
        if (null == this.ldapContext) {
            this.updateLdapContext();
        }
        return this.ldapContext;
    }

    protected void updateLdapContext() throws NamingException {
        this.ldapContext = this.computeLdapContext();
    }

    protected LdapContext computeLdapContext() throws NamingException {
        return new RetryingLdapContext(this.schedule, this.ldapConfiguration.getMaxRetries()){

            public Context newDelegate() throws NamingException {
                return new InitialLdapContext(ReadOnlyUsersLDAPRepository.this.getContextEnvironment(), null);
            }
        };
    }

    protected Properties getContextEnvironment() {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        props.put("java.naming.provider.url", Optional.ofNullable(this.ldapConfiguration.getLdapHost()).orElse(""));
        if (Strings.isNullOrEmpty((String)this.ldapConfiguration.getCredentials())) {
            props.put("java.naming.security.authentication", "none");
        } else {
            props.put("java.naming.security.authentication", "simple");
            props.put("java.naming.security.principal", Optional.ofNullable(this.ldapConfiguration.getPrincipal()).orElse(""));
            props.put("java.naming.security.credentials", this.ldapConfiguration.getCredentials());
        }
        props.put(PROPERTY_NAME_CONNECTION_POOL, String.valueOf(this.ldapConfiguration.useConnectionPool()));
        if (this.ldapConfiguration.getConnectionTimeout() > -1) {
            props.put(PROPERTY_NAME_CONNECT_TIMEOUT, String.valueOf(this.ldapConfiguration.getConnectionTimeout()));
        }
        if (this.ldapConfiguration.getReadTimeout() > -1) {
            props.put(PROPERTY_NAME_READ_TIMEOUT, Integer.toString(this.ldapConfiguration.getReadTimeout()));
        }
        return props;
    }

    private boolean userInGroupsMembershipList(String userDN, Map<String, Collection<String>> groupMembershipList) {
        boolean result = false;
        Collection<Collection<String>> memberLists = groupMembershipList.values();
        Iterator<Collection<String>> memberListsIterator = memberLists.iterator();
        while (memberListsIterator.hasNext() && !result) {
            Collection<String> groupMembers = memberListsIterator.next();
            result = groupMembers.contains(userDN);
        }
        return result;
    }

    private Set<String> getAllUsersFromLDAP() throws NamingException {
        HashSet<String> result = new HashSet<String>();
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        sc.setReturningAttributes(new String[]{"distinguishedName"});
        NamingEnumeration<SearchResult> sr = this.ldapContext.search(this.ldapConfiguration.getUserBase(), "(objectClass=" + this.ldapConfiguration.getUserObjectClass() + ")", sc);
        while (sr.hasMore()) {
            SearchResult r = sr.next();
            result.add(r.getNameInNamespace());
        }
        return result;
    }

    private Collection<ReadOnlyLDAPUser> buildUserCollection(Collection<String> userDNs) throws NamingException {
        ArrayList<ReadOnlyLDAPUser> results = new ArrayList<ReadOnlyLDAPUser>();
        for (String userDN : userDNs) {
            ReadOnlyLDAPUser user = this.buildUser(userDN);
            results.add(user);
        }
        return results;
    }

    private ReadOnlyLDAPUser searchAndBuildUser(String name) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        sc.setReturningAttributes(new String[]{this.ldapConfiguration.getUserIdAttribute()});
        sc.setCountLimit(1L);
        String filterTemplate = "(&({0}={1})(objectClass={2})" + StringUtils.defaultString((String)this.ldapConfiguration.getFilter(), (String)"") + ")";
        String sanitizedFilter = FilterEncoder.format((String)filterTemplate, (String[])new String[]{this.ldapConfiguration.getUserIdAttribute(), name, this.ldapConfiguration.getUserObjectClass()});
        NamingEnumeration<SearchResult> sr = this.ldapContext.search(this.ldapConfiguration.getUserBase(), sanitizedFilter, sc);
        if (!sr.hasMore()) {
            return null;
        }
        SearchResult r = sr.next();
        Attribute userName = r.getAttributes().get(this.ldapConfiguration.getUserIdAttribute());
        if (!this.ldapConfiguration.getRestriction().isActivated() || this.userInGroupsMembershipList(r.getNameInNamespace(), this.ldapConfiguration.getRestriction().getGroupMembershipLists(this.ldapContext))) {
            return new ReadOnlyLDAPUser(userName.get().toString(), r.getNameInNamespace(), this.ldapContext);
        }
        return null;
    }

    private ReadOnlyLDAPUser buildUser(String userDN) throws NamingException {
        Attributes userAttributes = this.ldapContext.getAttributes(userDN);
        Attribute userName = userAttributes.get(this.ldapConfiguration.getUserIdAttribute());
        return new ReadOnlyLDAPUser(userName.get().toString(), userDN, this.ldapContext);
    }

    public boolean contains(String name) throws UsersRepositoryException {
        return this.getUserByName(name) != null;
    }

    @Deprecated
    public boolean containsCaseInsensitive(String name) throws UsersRepositoryException {
        return this.getUserByNameCaseInsensitive(name) != null;
    }

    public int countUsers() throws UsersRepositoryException {
        try {
            return this.getValidUsers().size();
        }
        catch (NamingException e) {
            LOGGER.error("Unable to retrieve user count from ldap", (Throwable)e);
            throw new UsersRepositoryException("Unable to retrieve user count from ldap", (Throwable)e);
        }
    }

    @Deprecated
    public String getRealName(String name) throws UsersRepositoryException {
        org.apache.james.user.api.model.User u = this.getUserByNameCaseInsensitive(name);
        if (u != null) {
            return u.getUserName();
        }
        return null;
    }

    public org.apache.james.user.api.model.User getUserByName(String name) throws UsersRepositoryException {
        try {
            return this.searchAndBuildUser(name);
        }
        catch (NamingException e) {
            LOGGER.error("Unable to retrieve user from ldap", (Throwable)e);
            throw new UsersRepositoryException("Unable to retrieve user from ldap", (Throwable)e);
        }
    }

    @Deprecated
    public org.apache.james.user.api.model.User getUserByNameCaseInsensitive(String name) throws UsersRepositoryException {
        try {
            for (ReadOnlyLDAPUser u : this.buildUserCollection(this.getValidUsers())) {
                if (!u.getUserName().equalsIgnoreCase(name)) continue;
                return u;
            }
        }
        catch (NamingException e) {
            LOGGER.error("Unable to retrieve user from ldap", (Throwable)e);
            throw new UsersRepositoryException("Unable to retrieve user from ldap", (Throwable)e);
        }
        return null;
    }

    public Iterator<String> list() throws UsersRepositoryException {
        try {
            return ((ImmutableList)this.buildUserCollection(this.getValidUsers()).stream().map(ReadOnlyLDAPUser::getUserName).collect(Guavate.toImmutableList())).iterator();
        }
        catch (NamingException namingException) {
            throw new UsersRepositoryException("Unable to retrieve users list from LDAP due to unknown naming error.", (Throwable)namingException);
        }
    }

    private Collection<String> getValidUsers() throws NamingException {
        Collection<String> validUserDNs;
        Set<String> userDNs = this.getAllUsersFromLDAP();
        if (this.ldapConfiguration.getRestriction().isActivated()) {
            Map<String, Collection<String>> groupMembershipList = this.ldapConfiguration.getRestriction().getGroupMembershipLists(this.ldapContext);
            validUserDNs = new ArrayList();
            for (String userDN : userDNs) {
                if (!this.userInGroupsMembershipList(userDN, groupMembershipList)) continue;
                validUserDNs.add(userDN);
            }
        } else {
            validUserDNs = userDNs;
        }
        return validUserDNs;
    }

    public void removeUser(String name) throws UsersRepositoryException {
        LOGGER.warn("This user-repository is read-only. Modifications are not permitted.");
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        org.apache.james.user.api.model.User u = this.getUserByName(name);
        return u != null && u.verifyPassword(password);
    }

    public void addUser(String username, String password) throws UsersRepositoryException {
        LOGGER.error("This user-repository is read-only. Modifications are not permitted.");
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public void updateUser(org.apache.james.user.api.model.User user) throws UsersRepositoryException {
        LOGGER.error("This user-repository is read-only. Modifications are not permitted.");
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public boolean supportVirtualHosting() {
        return this.ldapConfiguration.supportsVirtualHosting();
    }

    public String getUser(MailAddress mailAddress) {
        if (this.supportVirtualHosting()) {
            return mailAddress.asString();
        }
        return mailAddress.getLocalPart();
    }

    public boolean isAdministrator(String username) {
        if (this.ldapConfiguration.getAdministratorId().isPresent()) {
            return this.ldapConfiguration.getAdministratorId().get().equals(username);
        }
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public MailAddress getMailAddressFor(User user) throws UsersRepositoryException {
        try {
            if (this.supportVirtualHosting()) {
                return new MailAddress(user.asString());
            }
            return new MailAddress(user.getLocalPart(), this.domainList.getDefaultDomain());
        }
        catch (Exception e) {
            throw new UsersRepositoryException("Failed to compute mail address associated with the user", (Throwable)e);
        }
    }
}

