/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.lib.netty.AbstractServerFactory;
import org.apache.james.smtpserver.netty.SMTPServer;
import org.apache.james.smtpserver.netty.SmtpMetricsImpl;
import org.jboss.netty.util.HashedWheelTimer;

public class SMTPServerFactory
extends AbstractServerFactory {
    protected final DNSService dns;
    protected final ProtocolHandlerLoader loader;
    protected final FileSystem fileSystem;
    protected final SmtpMetricsImpl smtpMetrics;
    private final HashedWheelTimer hashedWheelTimer;

    @Inject
    public SMTPServerFactory(DNSService dns, ProtocolHandlerLoader loader, FileSystem fileSystem, MetricFactory metricFactory, HashedWheelTimer hashedWheelTimer) {
        this.dns = dns;
        this.loader = loader;
        this.fileSystem = fileSystem;
        this.smtpMetrics = new SmtpMetricsImpl(metricFactory);
        this.hashedWheelTimer = hashedWheelTimer;
    }

    protected SMTPServer createServer() {
        return new SMTPServer(this.smtpMetrics);
    }

    protected List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration config) throws Exception {
        ArrayList<AbstractConfigurableAsyncServer> servers = new ArrayList<AbstractConfigurableAsyncServer>();
        List configs = config.configurationsAt("smtpserver");
        for (HierarchicalConfiguration serverConfig : configs) {
            SMTPServer server = this.createServer();
            server.setDnsService(this.dns);
            server.setProtocolHandlerLoader(this.loader);
            server.setFileSystem(this.fileSystem);
            server.setHashWheelTimer(this.hashedWheelTimer);
            server.configure(serverConfig);
            servers.add((AbstractConfigurableAsyncServer)server);
        }
        return servers;
    }
}

