/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class StreamUtils {
    public static <T> Stream<T> ofNullable(T[] array) {
        return StreamUtils.ofOptional(Optional.ofNullable(array));
    }

    public static <T> Stream<T> ofOptional(Optional<T[]> array) {
        return array.map(Arrays::stream).orElse(Stream.empty());
    }

    public static <T> Stream<T> flatten(Collection<Stream<T>> streams) {
        return StreamUtils.flatten(streams.stream());
    }

    public static <T> Stream<T> flatten(Stream<Stream<T>> streams) {
        return streams.flatMap(Function.identity());
    }

    @SafeVarargs
    public static <T> Stream<T> flatten(Stream<T> ... streams) {
        return StreamUtils.flatten(Arrays.stream(streams));
    }
}

