/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.james.util.FluentFutureStream;

public class Runnables {
    public static void runParallel(Runnable ... runnables) {
        FluentFutureStream.of(Arrays.stream(runnables).map(runnable -> CompletableFuture.supplyAsync(Runnables.toVoidSupplier(runnable)))).join();
    }

    private static Supplier<Void> toVoidSupplier(Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }
}

