/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class OptionalUtils {
    public static <T> Optional<T> executeIfEmpty(Optional<T> optional, Operation operation) {
        if (!optional.isPresent()) {
            operation.perform();
        }
        return optional;
    }

    public static <T> Stream<T> toStream(Optional<T> optional) {
        return optional.map(Stream::of).orElse(Stream.of(new Object[0]));
    }

    @SafeVarargs
    public static <T> Optional<T> or(Optional<T> ... optionals) {
        return OptionalUtils.orStream(Arrays.stream(optionals));
    }

    @SafeVarargs
    public static <T> Optional<T> orSuppliers(Supplier<Optional<T>> ... suppliers) {
        return OptionalUtils.orStream(Arrays.stream(suppliers).map(Supplier::get));
    }

    private static <T> Optional<T> orStream(Stream<Optional<T>> stream) {
        return stream.filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public static <T> boolean containsDifferent(Optional<T> requestValue, T storeValue) {
        return requestValue.filter(value -> !value.equals(storeValue)).isPresent();
    }

    @FunctionalInterface
    public static interface Operation {
        public void perform();
    }
}

