/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.james.util.CompletableFutureUtil;
import org.apache.james.util.OptionalUtils;

public class FluentFutureStream<T> {
    private final CompletableFuture<Stream<T>> completableFuture;

    public static <T> FluentFutureStream<T> of(CompletableFuture<Stream<T>> completableFuture) {
        return new FluentFutureStream<T>(completableFuture);
    }

    public static <T> FluentFutureStream<T> of(Stream<CompletableFuture<T>> completableFutureStream) {
        return new FluentFutureStream<T>(CompletableFutureUtil.allOf(completableFutureStream));
    }

    public static <T> FluentFutureStream<T> ofNestedStreams(Stream<CompletableFuture<Stream<T>>> completableFuture) {
        return FluentFutureStream.of(completableFuture).flatMap(Function.identity());
    }

    public static <T> FluentFutureStream<T> ofOptionals(Stream<CompletableFuture<Optional<T>>> completableFuture) {
        return FluentFutureStream.of(completableFuture).flatMapOptional(Function.identity());
    }

    @SafeVarargs
    public static <T> FluentFutureStream<T> ofFutures(CompletableFuture<T> ... completableFutures) {
        return new FluentFutureStream<T>(CompletableFutureUtil.allOfArray(completableFutures));
    }

    private FluentFutureStream(CompletableFuture<Stream<T>> completableFuture) {
        this.completableFuture = completableFuture;
    }

    public FluentFutureStream<T> performOnAll(Function<T, CompletableFuture<Void>> action) {
        return FluentFutureStream.of(CompletableFutureUtil.performOnAll(this.completableFuture(), action));
    }

    public <U> FluentFutureStream<U> map(Function<T, U> function) {
        return FluentFutureStream.of(CompletableFutureUtil.map(this.completableFuture(), function));
    }

    public <U> FluentFutureStream<U> flatMap(Function<T, Stream<U>> function) {
        return FluentFutureStream.of(this.completableFuture().thenApply(stream -> stream.flatMap(function)));
    }

    public <U> FluentFutureStream<U> flatMapOptional(Function<T, Optional<U>> function) {
        return this.map(function).flatMap(OptionalUtils::toStream);
    }

    public <U> FluentFutureStream<U> thenComposeOnAll(Function<T, CompletableFuture<U>> function) {
        return FluentFutureStream.of(CompletableFutureUtil.thenComposeOnAll(this.completableFuture(), function));
    }

    public <U> FluentFutureStream<U> thenFlatCompose(Function<T, CompletableFuture<Stream<U>>> function) {
        return FluentFutureStream.of(CompletableFutureUtil.thenComposeOnAll(this.completableFuture(), function)).flatMap(Function.identity());
    }

    public <U> FluentFutureStream<U> thenFlatComposeOnOptional(Function<T, CompletableFuture<Optional<U>>> function) {
        return FluentFutureStream.of(CompletableFutureUtil.thenComposeOnAll(this.completableFuture(), function)).flatMapOptional(Function.identity());
    }

    public FluentFutureStream<T> filter(Predicate<T> predicate) {
        return FluentFutureStream.of(this.completableFuture.thenApply(stream -> stream.filter(predicate)));
    }

    public CompletableFuture<Optional<T>> reduce(BinaryOperator<T> combiner) {
        return CompletableFutureUtil.reduce(combiner, this.completableFuture);
    }

    public CompletableFuture<T> reduce(T emptyAccumulator, BinaryOperator<T> combiner) {
        return CompletableFutureUtil.reduce(combiner, this.completableFuture, emptyAccumulator);
    }

    public CompletableFuture<Stream<T>> completableFuture() {
        return this.completableFuture;
    }

    public <C> CompletableFuture<C> collect(Collector<T, ?, C> collector) {
        return this.completableFuture.thenApply(stream -> stream.collect(collector));
    }

    public Stream<T> join() {
        return this.completableFuture().join();
    }
}

