/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.domainlist.api.DomainListManagementMBean;
import org.apache.james.probe.DataProbe;
import org.apache.james.rrt.api.RecipientRewriteTableManagementMBean;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.user.api.UsersRepositoryManagementMBean;
import org.apache.james.util.MDCBuilder;

public class JmxDataProbe
implements DataProbe,
JmxProbe {
    private static final String DOMAINLIST_OBJECT_NAME = "org.apache.james:type=component,name=domainlist";
    private static final String VIRTUALUSERTABLE_OBJECT_NAME = "org.apache.james:type=component,name=recipientrewritetable";
    private static final String USERSREPOSITORY_OBJECT_NAME = "org.apache.james:type=component,name=usersrepository";
    private static final String JMX = "JMX";
    private DomainListManagementMBean domainListProxy;
    private RecipientRewriteTableManagementMBean virtualUserTableProxy;
    private UsersRepositoryManagementMBean usersRepositoryProxy;

    @Override
    public JmxDataProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.domainListProxy = jmxc.retrieveBean(DomainListManagementMBean.class, DOMAINLIST_OBJECT_NAME);
            this.virtualUserTableProxy = jmxc.retrieveBean(RecipientRewriteTableManagementMBean.class, VIRTUALUSERTABLE_OBJECT_NAME);
            this.usersRepositoryProxy = jmxc.retrieveBean(UsersRepositoryManagementMBean.class, USERSREPOSITORY_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public void addUser(String userName, String password) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"addUser").addContext("parameter", (Object)userName).build();){
            this.usersRepositoryProxy.addUser(userName, password);
        }
    }

    public void removeUser(String username) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"removeUser").addContext("parameter", (Object)username).build();){
            this.usersRepositoryProxy.deleteUser(username);
        }
    }

    public String[] listUsers() throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"listUsers").build();){
            String[] stringArray = this.usersRepositoryProxy.listAllUsers();
            return stringArray;
        }
    }

    public void setPassword(String userName, String password) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"setPassword").addContext("parameter", (Object)userName).build();){
            this.usersRepositoryProxy.setPassword(userName, password);
        }
    }

    public boolean containsDomain(String domain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"containsDomain").addContext("parameter", (Object)domain).build();){
            boolean bl = this.domainListProxy.containsDomain(domain);
            return bl;
        }
    }

    public String getDefaultDomain() throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"getDefaultDomain").build();){
            String string = this.domainListProxy.getDefaultDomain();
            return string;
        }
    }

    public void addDomain(String domain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"addDomain").addContext("parameter", (Object)domain).build();){
            this.domainListProxy.addDomain(domain);
        }
    }

    public void removeDomain(String domain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"removeDomain").addContext("parameter", (Object)domain).build();){
            this.domainListProxy.removeDomain(domain);
        }
    }

    public List<String> listDomains() throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"listDomains").build();){
            List list = this.domainListProxy.getDomains();
            return list;
        }
    }

    public Map<String, Mappings> listMappings() throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"listMappings").build();){
            Map map = this.virtualUserTableProxy.getAllMappings();
            return map;
        }
    }

    public void addAddressMapping(String fromUser, String fromDomain, String toAddress) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"addAddressMapping").build();){
            this.virtualUserTableProxy.addAddressMapping(fromUser, fromDomain, toAddress);
        }
    }

    public void removeAddressMapping(String fromUser, String fromDomain, String toAddress) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"removeAddressMapping").build();){
            this.virtualUserTableProxy.removeAddressMapping(fromUser, fromDomain, toAddress);
        }
    }

    public Mappings listUserDomainMappings(String user, String domain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"listUserDomainMappings").build();){
            Mappings mappings = this.virtualUserTableProxy.getUserDomainMappings(user, domain);
            return mappings;
        }
    }

    public void addRegexMapping(String user, String domain, String regex) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"addRegexMapping").build();){
            this.virtualUserTableProxy.addRegexMapping(user, domain, regex);
        }
    }

    public void removeRegexMapping(String user, String domain, String regex) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"removeRegexMapping").build();){
            this.virtualUserTableProxy.removeRegexMapping(user, domain, regex);
        }
    }

    public void addDomainAliasMapping(String aliasDomain, String deliveryDomain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"addDomainAliasMapping").build();){
            this.virtualUserTableProxy.addDomainMapping(aliasDomain, deliveryDomain);
        }
    }

    public void addForwardMapping(String user, String domain, String address) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"addForwardMapping").build();){
            this.virtualUserTableProxy.addForwardMapping(user, domain, address);
        }
    }

    public void removeForwardMapping(String user, String domain, String address) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"removeForwardMapping").build();){
            this.virtualUserTableProxy.removeForwardMapping(user, domain, address);
        }
    }

    public void addGroupMapping(String toUser, String toDomain, String fromAddress) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"removeForwardMapping").build();){
            this.virtualUserTableProxy.addGroupMapping(toUser, toDomain, fromAddress);
        }
    }

    public void removeGroupMapping(String toUser, String toDomain, String fromAddress) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)JMX).addContext("action", (Object)"removeForwardMapping").build();){
            this.virtualUserTableProxy.removeGroupMapping(toUser, toDomain, fromAddress);
        }
    }
}

