/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.lib;

import javax.inject.Inject;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.core.User;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.SieveRepositoryManagementMBean;
import org.apache.james.sieverepository.api.exception.SieveRepositoryException;

public class SieveRepositoryManagement
extends StandardMBean
implements SieveRepositoryManagementMBean {
    private SieveRepository sieveRepository;

    public SieveRepositoryManagement() throws NotCompliantMBeanException {
        super(SieveRepositoryManagementMBean.class);
    }

    @Inject
    public void setSieveRepository(SieveRepository sieveRepository) {
        this.sieveRepository = sieveRepository;
    }

    public long getQuota() throws SieveRepositoryException {
        return this.sieveRepository.getDefaultQuota().asLong();
    }

    public void setQuota(long quota) throws SieveRepositoryException {
        this.sieveRepository.setDefaultQuota(QuotaSize.size((long)quota));
    }

    public void removeQuota() throws SieveRepositoryException {
        this.sieveRepository.removeQuota();
    }

    public long getQuota(String user) throws SieveRepositoryException {
        return this.sieveRepository.getQuota(User.fromUsername((String)user)).asLong();
    }

    public void setQuota(String user, long quota) throws SieveRepositoryException {
        this.sieveRepository.setQuota(User.fromUsername((String)user), QuotaSize.size((long)quota));
    }

    public void removeQuota(String user) throws SieveRepositoryException {
        this.sieveRepository.removeQuota(User.fromUsername((String)user));
    }
}

