/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.github.steveash.guavate.Guavate;
import java.util.Map;
import javax.inject.Inject;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.RecipientRewriteTableManagementMBean;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;

public class RecipientRewriteTableManagement
extends StandardMBean
implements RecipientRewriteTableManagementMBean {
    private final RecipientRewriteTable rrt;

    @Inject
    protected RecipientRewriteTableManagement(RecipientRewriteTable rrt) throws NotCompliantMBeanException {
        super(RecipientRewriteTableManagementMBean.class);
        this.rrt = rrt;
    }

    public void addRegexMapping(String user, String domain, String regex) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(user, domain);
        this.rrt.addRegexMapping(source, regex);
    }

    public void removeRegexMapping(String user, String domain, String regex) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(user, domain);
        this.rrt.removeRegexMapping(source, regex);
    }

    public void addAddressMapping(String fromUser, String fromDomain, String toAddress) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(fromUser, fromDomain);
        this.rrt.addAddressMapping(source, toAddress);
    }

    public void removeAddressMapping(String fromUser, String fromDomain, String toAddress) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(fromUser, fromDomain);
        this.rrt.removeAddressMapping(source, toAddress);
    }

    public void addErrorMapping(String user, String domain, String error) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(user, domain);
        this.rrt.addErrorMapping(source, error);
    }

    public void removeErrorMapping(String user, String domain, String error) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(user, domain);
        this.rrt.removeErrorMapping(source, error);
    }

    public void addDomainMapping(String domain, String targetDomain) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromDomain(Domain.of((String)domain));
        this.rrt.addAliasDomainMapping(source, Domain.of((String)targetDomain));
    }

    public void removeDomainMapping(String domain, String targetDomain) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromDomain(Domain.of((String)domain));
        this.rrt.removeAliasDomainMapping(source, Domain.of((String)targetDomain));
    }

    public Mappings getUserDomainMappings(String user, String domain) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(user, domain);
        return this.rrt.getUserDomainMappings(source);
    }

    public void addMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(user, domain);
        this.rrt.addMapping(source, Mapping.of(mapping));
    }

    public void removeMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(user, domain);
        this.rrt.removeMapping(source, Mapping.of(mapping));
    }

    public Map<String, Mappings> getAllMappings() throws RecipientRewriteTableException {
        return (Map)this.rrt.getAllMappings().entrySet().stream().collect(Guavate.toImmutableMap(entry -> ((MappingSource)entry.getKey()).asString(), entry -> (Mappings)entry.getValue()));
    }

    public void addForwardMapping(String user, String domain, String address) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(user, domain);
        this.rrt.addForwardMapping(source, address);
    }

    public void removeForwardMapping(String user, String domain, String address) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(user, domain);
        this.rrt.removeForwardMapping(source, address);
    }

    public void addGroupMapping(String toUser, String toDomain, String fromAddress) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(toUser, toDomain);
        this.rrt.addGroupMapping(source, fromAddress);
    }

    public void removeGroupMapping(String toUser, String toDomain, String fromAddress) throws RecipientRewriteTableException {
        MappingSource source = MappingSource.fromUser(toUser, toDomain);
        this.rrt.removeForwardMapping(source, fromAddress);
    }
}

