/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.github.fge.lambdas.Throwing;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.Domain;
import org.apache.james.core.User;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.rrt.api.MappingAlreadyExistsException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.rrt.lib.SkipMappingProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecipientRewriteTable
implements RecipientRewriteTable,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRecipientRewriteTable.class);
    private int mappingLimit = 10;
    private boolean recursive = true;
    private DomainList domainList;

    @Inject
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.setRecursiveMapping(config.getBoolean("recursiveMapping", true));
        try {
            this.setMappingLimit(config.getInt("mappingLimit", 10));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage());
        }
        this.doConfigure(config);
    }

    protected void doConfigure(HierarchicalConfiguration conf) throws ConfigurationException {
    }

    public void setRecursiveMapping(boolean recursive) {
        this.recursive = recursive;
    }

    public void setMappingLimit(int mappingLimit) throws IllegalArgumentException {
        if (mappingLimit < 1) {
            throw new IllegalArgumentException("The minimum mappingLimit is 1");
        }
        this.mappingLimit = mappingLimit;
    }

    public Mappings getMappings(String user, Domain domain) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        return this.getMappings(User.fromLocalPartWithDomain((String)user, (Domain)domain), this.mappingLimit);
    }

    private Mappings getMappings(User user, int mappingLimit) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        if (mappingLimit == 0) {
            throw new RecipientRewriteTable.TooManyMappingException("554 Too many mappings to process");
        }
        Mappings targetMappings = this.mapAddress(user.getLocalPart(), (Domain)user.getDomainPart().get());
        try {
            return MappingsImpl.fromMappings(targetMappings.asStream().flatMap(Throwing.function(target -> this.convertAndRecurseMapping(user, (Mapping)target, mappingLimit)).sneakyThrow()));
        }
        catch (SkipMappingProcessingException e) {
            return MappingsImpl.empty();
        }
    }

    private Stream<Mapping> convertAndRecurseMapping(User originalUser, Mapping associatedMapping, int remainingLoops) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException, SkipMappingProcessingException, AddressException {
        Function convertAndRecurseMapping = Throwing.function(rewrittenUser -> this.convertAndRecurseMapping(associatedMapping, originalUser, (User)rewrittenUser, remainingLoops)).sneakyThrow();
        return associatedMapping.rewriteUser(originalUser).map(rewrittenUser -> rewrittenUser.withDefaultDomainFromUser(originalUser)).map(convertAndRecurseMapping).orElse(Stream.empty());
    }

    private Stream<Mapping> convertAndRecurseMapping(Mapping mapping, User originalUser, User rewrittenUser, int remainingLoops) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        LOGGER.debug("Valid virtual user mapping {} to {}", (Object)originalUser, (Object)rewrittenUser);
        Stream<Mapping> nonRecursiveResult = Stream.of(this.toMapping(rewrittenUser, mapping.getType()));
        if (!this.recursive) {
            return nonRecursiveResult;
        }
        if (originalUser.equals((Object)rewrittenUser)) {
            return mapping.handleIdentity(nonRecursiveResult);
        }
        return this.recurseMapping(nonRecursiveResult, rewrittenUser, remainingLoops);
    }

    private Stream<Mapping> recurseMapping(Stream<Mapping> nonRecursiveResult, User targetUser, int remainingLoops) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        Mappings childMappings = this.getMappings(targetUser, remainingLoops - 1);
        if (childMappings.isEmpty()) {
            return nonRecursiveResult;
        }
        return childMappings.asStream();
    }

    private Mapping toMapping(User rewrittenUser, Mapping.Type type) {
        switch (type) {
            case Forward: 
            case Group: {
                return Mapping.of(type, rewrittenUser.asString());
            }
            case Regex: 
            case Domain: 
            case Error: 
            case Address: {
                return Mapping.address(rewrittenUser.asString());
            }
        }
        throw new IllegalArgumentException("unhandled enum type");
    }

    public void addRegexMapping(MappingSource source, String regex) throws RecipientRewriteTableException {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new RecipientRewriteTableException("Invalid regex: " + regex, (Throwable)e);
        }
        Mapping mapping = Mapping.regex(regex);
        this.checkDuplicateMapping(source, mapping);
        LOGGER.info("Add regex mapping => {} for source {}", (Object)regex, (Object)source.asString());
        this.addMapping(source, mapping);
    }

    public void removeRegexMapping(MappingSource source, String regex) throws RecipientRewriteTableException {
        LOGGER.info("Remove regex mapping => {} for source: {}", (Object)regex, (Object)source.asString());
        this.removeMapping(source, Mapping.regex(regex));
    }

    public void addAddressMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.address(address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        this.checkHasValidAddress(mapping);
        this.checkDuplicateMapping(source, mapping);
        LOGGER.info("Add address mapping => {} for source: {}", (Object)mapping, (Object)source.asString());
        this.addMapping(source, mapping);
    }

    private Domain defaultDomain() throws RecipientRewriteTableException {
        try {
            return this.domainList.getDefaultDomain();
        }
        catch (DomainListException e) {
            throw new RecipientRewriteTableException("Unable to retrieve default domain", (Throwable)e);
        }
    }

    private void checkHasValidAddress(Mapping mapping) throws RecipientRewriteTableException {
        if (!mapping.asMailAddress().isPresent()) {
            throw new RecipientRewriteTableException("Invalid emailAddress: " + mapping);
        }
    }

    public void removeAddressMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.address(address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        LOGGER.info("Remove address mapping => {} for source: {}", (Object)mapping, (Object)source.asString());
        this.removeMapping(source, mapping);
    }

    public void addErrorMapping(MappingSource source, String error) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.error(error);
        this.checkDuplicateMapping(source, mapping);
        LOGGER.info("Add error mapping => {} for source: {}", (Object)error, (Object)source.asString());
        this.addMapping(source, mapping);
    }

    public void removeErrorMapping(MappingSource source, String error) throws RecipientRewriteTableException {
        LOGGER.info("Remove error mapping => {} for source: {}", (Object)error, (Object)source.asString());
        this.removeMapping(source, Mapping.error(error));
    }

    public void addAliasDomainMapping(MappingSource source, Domain realDomain) throws RecipientRewriteTableException {
        LOGGER.info("Add domain mapping: {} => {}", (Object)source.asDomain().map(Domain::asString).orElse("null"), (Object)realDomain);
        this.addMapping(source, Mapping.domain(realDomain));
    }

    public void removeAliasDomainMapping(MappingSource source, Domain realDomain) throws RecipientRewriteTableException {
        LOGGER.info("Remove domain mapping: {} => {}", (Object)source.asDomain().map(Domain::asString).orElse("null"), (Object)realDomain);
        this.removeMapping(source, Mapping.domain(realDomain));
    }

    public void addForwardMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.forward(address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        this.checkHasValidAddress(mapping);
        this.checkDuplicateMapping(source, mapping);
        LOGGER.info("Add forward mapping => {} for source: {}", (Object)mapping, (Object)source.asString());
        this.addMapping(source, mapping);
    }

    public void removeForwardMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.forward(address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        LOGGER.info("Remove forward mapping => {} for source: {}", (Object)mapping, (Object)source.asString());
        this.removeMapping(source, mapping);
    }

    public void addGroupMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.group(address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        this.checkHasValidAddress(mapping);
        this.checkDuplicateMapping(source, mapping);
        LOGGER.info("Add group mapping => {} for source: {}", (Object)mapping, (Object)source.asString());
        this.addMapping(source, mapping);
    }

    public void removeGroupMapping(MappingSource source, String address) throws RecipientRewriteTableException {
        Mapping mapping = Mapping.group(address).appendDomainFromThrowingSupplierIfNone(this::defaultDomain);
        LOGGER.info("Remove group mapping => {} for source: {}", (Object)mapping, (Object)source.asString());
        this.removeMapping(source, mapping);
    }

    public abstract Map<MappingSource, Mappings> getAllMappings() throws RecipientRewriteTableException;

    protected abstract Mappings mapAddress(String var1, Domain var2) throws RecipientRewriteTableException;

    private void checkDuplicateMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        Mappings mappings = this.getUserDomainMappings(source);
        if (mappings != null && mappings.contains(mapping)) {
            throw new MappingAlreadyExistsException("Mapping " + mapping + " for " + source.asString() + " already exist!");
        }
    }
}

