/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing.aggregates;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.eventsourcing.aggregates.DLPAggregateId;
import org.apache.james.dlp.eventsourcing.events.ConfigurationItemsAdded;
import org.apache.james.dlp.eventsourcing.events.ConfigurationItemsRemoved;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.util.OptionalUtils;

public class DLPDomainConfiguration {
    private final DLPAggregateId aggregateId;
    private final History history;
    private State state;

    public static DLPDomainConfiguration load(DLPAggregateId aggregateId, History history) {
        return new DLPDomainConfiguration(aggregateId, history);
    }

    private DLPDomainConfiguration(DLPAggregateId aggregateId, History history) {
        this.aggregateId = aggregateId;
        this.state = State.initial();
        history.getEvents().forEach(this::apply);
        this.history = history;
    }

    public Stream<DLPConfigurationItem> retrieveRules() {
        return this.state.rules.stream();
    }

    public List<Event> clear() {
        ImmutableList rules = (ImmutableList)this.retrieveRules().collect(Guavate.toImmutableList());
        if (!rules.isEmpty()) {
            ImmutableList events = ImmutableList.of((Object)new ConfigurationItemsRemoved(this.aggregateId, this.history.getNextEventId(), (Collection<DLPConfigurationItem>)rules));
            events.forEach(this::apply);
            return events;
        }
        return ImmutableList.of();
    }

    public List<Event> store(List<DLPConfigurationItem> updatedRules) {
        ImmutableSet existingRules = (ImmutableSet)this.retrieveRules().collect(Guavate.toImmutableSet());
        ImmutableSet updatedRulesSet = ImmutableSet.copyOf(updatedRules);
        Optional<Event> removedRulesEvent = this.generateRemovedRulesEvent((ImmutableSet<DLPConfigurationItem>)existingRules, (ImmutableSet<DLPConfigurationItem>)updatedRulesSet);
        Optional<Event> addedRulesEvent = this.generateAddedRulesEvent((Set<DLPConfigurationItem>)existingRules, (Set<DLPConfigurationItem>)updatedRulesSet, this.computeNextEventId(removedRulesEvent));
        ImmutableList events = (ImmutableList)Stream.of(removedRulesEvent, addedRulesEvent).flatMap(OptionalUtils::toStream).collect(Guavate.toImmutableList());
        events.forEach(this::apply);
        return events;
    }

    private EventId computeNextEventId(Optional<Event> removedRulesEvent) {
        return removedRulesEvent.map(Event::eventId).map(EventId::next).orElse(this.history.getNextEventId());
    }

    private Optional<Event> generateRemovedRulesEvent(ImmutableSet<DLPConfigurationItem> existingRules, ImmutableSet<DLPConfigurationItem> updateRulesSet) {
        Sets.SetView removedRules = Sets.difference(existingRules, updateRulesSet);
        if (!removedRules.isEmpty()) {
            return Optional.of(new ConfigurationItemsRemoved(this.aggregateId, this.history.getNextEventId(), (Collection<DLPConfigurationItem>)removedRules));
        }
        return Optional.empty();
    }

    private Optional<Event> generateAddedRulesEvent(Set<DLPConfigurationItem> existingRules, Set<DLPConfigurationItem> updateRulesSet, EventId nextEventId) {
        Sets.SetView addedRules = Sets.difference(updateRulesSet, existingRules);
        if (!addedRules.isEmpty()) {
            return Optional.of(new ConfigurationItemsAdded(this.aggregateId, nextEventId, (Collection<DLPConfigurationItem>)addedRules));
        }
        return Optional.empty();
    }

    private void apply(Event event) {
        if (event instanceof ConfigurationItemsAdded) {
            this.state = this.state.add(((ConfigurationItemsAdded)event).getRules());
        }
        if (event instanceof ConfigurationItemsRemoved) {
            this.state = this.state.remove(((ConfigurationItemsRemoved)event).getRules());
        }
    }

    private static class State {
        final ImmutableSet<DLPConfigurationItem> rules;

        static State initial() {
            return new State((ImmutableSet<DLPConfigurationItem>)ImmutableSet.of());
        }

        private State(ImmutableSet<DLPConfigurationItem> rules) {
            this.rules = rules;
        }

        State add(List<DLPConfigurationItem> toAdd) {
            ImmutableSet union = (ImmutableSet)Stream.concat(this.rules.stream(), toAdd.stream()).collect(Guavate.toImmutableSet());
            return new State((ImmutableSet<DLPConfigurationItem>)union);
        }

        State remove(List<DLPConfigurationItem> toRemove) {
            ImmutableSet filtered = (ImmutableSet)this.rules.stream().filter(rule -> !toRemove.contains(rule)).collect(Guavate.toImmutableSet());
            return new State((ImmutableSet<DLPConfigurationItem>)filtered);
        }
    }
}

